/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class XMLElement {
    private static final String HEADER = "<?xml version=\"1.0\" encoding=\"%s\"?>";
    private static final String HEADER_STANDALONE = "<?xml version=\"1.0\" encoding=\"%s\" standalone=\"yes\"?>";
    private static final String DOCTYPE = "<!DOCTYPE %s PUBLIC \"%s\" \"%s\">";
    protected final Writer writer;
    private final String name;
    private boolean openTagDone;
    private boolean closed;
    private XMLElement lastchild;
    private final boolean root;

    private XMLElement(Writer writer, String name, boolean root) throws IOException {
        this.writer = writer;
        this.name = name;
        this.openTagDone = false;
        this.closed = false;
        this.lastchild = null;
        this.root = root;
    }

    public XMLElement(String name, String pubId, String system, boolean standalone, String encoding, OutputStream output) throws IOException {
        this(new OutputStreamWriter(output, encoding), name, true);
        if (standalone) {
            this.writer.write(String.format(HEADER_STANDALONE, encoding));
        } else {
            this.writer.write(String.format(HEADER, encoding));
        }
        if (pubId != null) {
            this.writer.write(String.format(DOCTYPE, name, pubId, system));
        }
        this.writer.write(60);
        this.writer.write(name);
    }

    protected XMLElement(String name, XMLElement parent) throws IOException {
        this(parent.writer, name, false);
        parent.addChildElement(this);
        this.writer.write(60);
        this.writer.write(name);
    }

    private void addChildElement(XMLElement child) throws IOException {
        if (this.closed) {
            throw new IOException(String.format("Element %s already closed.", this.name));
        }
        this.finishOpenTag();
        if (this.lastchild != null) {
            this.lastchild.close();
        }
        this.lastchild = child;
    }

    private void finishOpenTag() throws IOException {
        if (!this.openTagDone) {
            this.writer.append('>');
            this.openTagDone = true;
        }
    }

    private void quote(String text) throws IOException {
        int len = text.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    this.writer.write("&lt;");
                    continue block6;
                }
                case '>': {
                    this.writer.write("&gt;");
                    continue block6;
                }
                case '\"': {
                    this.writer.write("&quot;");
                    continue block6;
                }
                case '&': {
                    this.writer.write("&amp;");
                    continue block6;
                }
                default: {
                    this.writer.write(c);
                }
            }
        }
    }

    public final void attr(String name, String value) throws IOException {
        if (value == null) {
            return;
        }
        if (this.closed || this.openTagDone) {
            throw new IOException(String.format("Element %s already closed.", this.name));
        }
        this.writer.write(32);
        this.writer.write(name);
        this.writer.write(61);
        this.writer.write(34);
        this.quote(value);
        this.writer.write(34);
    }

    public final void attr(String name, int value) throws IOException {
        this.attr(name, String.valueOf(value));
    }

    public final void attr(String name, long value) throws IOException {
        this.attr(name, String.valueOf(value));
    }

    public final void text(String text) throws IOException {
        if (this.closed) {
            throw new IOException(String.format("Element %s already closed.", this.name));
        }
        this.finishOpenTag();
        if (this.lastchild != null) {
            this.lastchild.close();
        }
        this.quote(text);
    }

    public XMLElement element(String name) throws IOException {
        return new XMLElement(name, this);
    }

    public final void close() throws IOException {
        if (!this.closed) {
            if (this.lastchild != null) {
                this.lastchild.close();
            }
            if (this.openTagDone) {
                this.writer.write(60);
                this.writer.write(47);
                this.writer.write(this.name);
            } else {
                this.writer.write(47);
            }
            this.writer.write(62);
            this.closed = true;
            this.openTagDone = true;
            if (this.root) {
                this.writer.close();
            }
        }
    }
}

