/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.lang.ref.WeakReference;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.LoggingMXBean;
import java.util.logging.LoggingPermission;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.LoggerNode;
import org.jboss.logmanager.LoggingMXBeanImpl;
import org.jboss.logmanager.Protectable;

public final class LogContext
implements Protectable {
    private static final LogContext SYSTEM_CONTEXT = new LogContext();
    static final Permission CREATE_CONTEXT_PERMISSION = new RuntimePermission("createLogContext", null);
    static final Permission SET_CONTEXT_SELECTOR_PERMISSION = new RuntimePermission("setLogContextSelector", null);
    static final Permission CONTROL_PERMISSION = new LoggingPermission("control", null);
    private final LoggerNode rootLogger = new LoggerNode(this);
    private final LoggingMXBean mxBean = new LoggingMXBeanImpl(this);
    private volatile Object protectKey;
    private final ThreadLocal<Boolean> granted = new InheritableThreadLocal<Boolean>();
    private static final AtomicReferenceFieldUpdater<LogContext, Object> protectKeyUpdater = AtomicReferenceFieldUpdater.newUpdater(LogContext.class, Object.class, "protectKey");
    private final AtomicReference<Map<String, LevelRef>> levelMapReference;
    final Object treeLock = new Object();
    public static final LogContextSelector DEFAULT_LOG_CONTEXT_SELECTOR;
    private static volatile LogContextSelector logContextSelector;

    LogContext() {
        this.levelMapReference = new AtomicReference<HashMap>(LazyHolder.INITIAL_LEVEL_MAP);
    }

    public static LogContext create() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_CONTEXT_PERMISSION);
        }
        return new LogContext();
    }

    public Logger getLogger(String name) {
        return this.rootLogger.getOrCreate(name).createLogger();
    }

    public Logger getLoggerIfExists(String name) {
        LoggerNode node = this.rootLogger.getIfExists(name);
        return node == null ? null : node.createLogger();
    }

    public <V> V getAttachment(String loggerName, Logger.AttachmentKey<V> key) {
        LoggerNode node = this.rootLogger.getIfExists(loggerName);
        if (node == null) {
            return null;
        }
        return node.getAttachment(key);
    }

    public LoggingMXBean getLoggingMXBean() {
        return this.mxBean;
    }

    public java.util.logging.Level getLevelForName(String name) throws IllegalArgumentException {
        java.util.logging.Level level;
        Map<String, LevelRef> map;
        LevelRef levelRef;
        if (name != null && (levelRef = (map = this.levelMapReference.get()).get(name)) != null && (level = levelRef.get()) != null) {
            return level;
        }
        throw new IllegalArgumentException("Unknown level \"" + name + "\"");
    }

    public void registerLevel(java.util.logging.Level level) {
        HashMap<String, LevelRef> newLevelMap;
        Map<String, LevelRef> oldLevelMap;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
        do {
            oldLevelMap = this.levelMapReference.get();
            newLevelMap = new HashMap<String, LevelRef>(oldLevelMap.size());
            for (Map.Entry<String, LevelRef> entry : oldLevelMap.entrySet()) {
                String name = entry.getKey();
                LevelRef levelRef = entry.getValue();
                if (levelRef.get() == null) continue;
                newLevelMap.put(name, levelRef);
            }
            newLevelMap.put(level.getName(), new WeakLevelRef(level));
        } while (!this.levelMapReference.compareAndSet(oldLevelMap, newLevelMap));
    }

    public void unregisterLevel(java.util.logging.Level level) {
        HashMap<String, LevelRef> newLevelMap;
        Map<String, LevelRef> oldLevelMap;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
        do {
            LevelRef oldRef;
            if ((oldRef = (oldLevelMap = this.levelMapReference.get()).get(level.getName())) == null || oldRef.get() != level) {
                return;
            }
            newLevelMap = new HashMap<String, LevelRef>(oldLevelMap.size());
            for (Map.Entry<String, LevelRef> entry : oldLevelMap.entrySet()) {
                String name = entry.getKey();
                LevelRef levelRef = entry.getValue();
                java.util.logging.Level oldLevel = levelRef.get();
                if (oldLevel == null || oldLevel == level) continue;
                newLevelMap.put(name, levelRef);
            }
            newLevelMap.put(level.getName(), new WeakLevelRef(level));
        } while (!this.levelMapReference.compareAndSet(oldLevelMap, newLevelMap));
    }

    public static LogContext getSystemLogContext() {
        return SYSTEM_CONTEXT;
    }

    public static LogContext getLogContext() {
        return logContextSelector.getLogContext();
    }

    public static void setLogContextSelector(LogContextSelector newSelector) {
        if (newSelector == null) {
            throw new NullPointerException("newSelector is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_CONTEXT_SELECTOR_PERMISSION);
        }
        logContextSelector = newSelector;
    }

    @Override
    public void protect(Object protectionKey) throws SecurityException {
        if (protectKeyUpdater.compareAndSet(this, null, protectionKey)) {
            return;
        }
        throw new SecurityException("Log context already protected");
    }

    @Override
    public void unprotect(Object protectionKey) throws SecurityException {
        if (protectKeyUpdater.compareAndSet(this, protectionKey, null)) {
            return;
        }
        throw LogContext.accessDenied();
    }

    @Override
    public void enableAccess(Object protectKey) throws SecurityException {
        if (protectKey == this.protectKey) {
            this.granted.set(Boolean.TRUE);
        }
    }

    @Override
    public void disableAccess() {
        this.granted.remove();
    }

    private static SecurityException accessDenied() {
        return new SecurityException("Log context modification access denied");
    }

    static void checkAccess(LogContext logContext) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONTROL_PERMISSION);
        }
        if (logContext.protectKey != null && logContext.granted.get() == null) {
            throw LogContext.accessDenied();
        }
    }

    LoggerNode getRootLoggerNode() {
        return this.rootLogger;
    }

    static {
        logContextSelector = DEFAULT_LOG_CONTEXT_SELECTOR = new LogContextSelector(){

            @Override
            public LogContext getLogContext() {
                return SYSTEM_CONTEXT;
            }
        };
    }

    private static final class StrongLevelRef
    implements LevelRef {
        private final java.util.logging.Level level;

        private StrongLevelRef(java.util.logging.Level level) {
            this.level = level;
        }

        @Override
        public java.util.logging.Level get() {
            return this.level;
        }
    }

    private static final class WeakLevelRef
    extends WeakReference<java.util.logging.Level>
    implements LevelRef {
        private WeakLevelRef(java.util.logging.Level level) {
            super(level);
        }
    }

    private static interface LevelRef {
        public java.util.logging.Level get();
    }

    private static final class LazyHolder {
        private static final HashMap<String, LevelRef> INITIAL_LEVEL_MAP;

        private LazyHolder() {
        }

        private static void addStrong(Map<String, LevelRef> map, java.util.logging.Level level) {
            map.put(level.getName().toUpperCase(), new StrongLevelRef(level));
        }

        static {
            HashMap<String, LevelRef> map = new HashMap<String, LevelRef>();
            LazyHolder.addStrong(map, java.util.logging.Level.OFF);
            LazyHolder.addStrong(map, java.util.logging.Level.ALL);
            LazyHolder.addStrong(map, java.util.logging.Level.SEVERE);
            LazyHolder.addStrong(map, java.util.logging.Level.WARNING);
            LazyHolder.addStrong(map, java.util.logging.Level.CONFIG);
            LazyHolder.addStrong(map, java.util.logging.Level.INFO);
            LazyHolder.addStrong(map, java.util.logging.Level.FINE);
            LazyHolder.addStrong(map, java.util.logging.Level.FINER);
            LazyHolder.addStrong(map, java.util.logging.Level.FINEST);
            LazyHolder.addStrong(map, Level.FATAL);
            LazyHolder.addStrong(map, Level.ERROR);
            LazyHolder.addStrong(map, Level.WARN);
            LazyHolder.addStrong(map, Level.INFO);
            LazyHolder.addStrong(map, Level.DEBUG);
            LazyHolder.addStrong(map, Level.TRACE);
            INITIAL_LEVEL_MAP = map;
        }
    }
}

