/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dsx.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dsx.DSXAdapters;
import org.knowm.xchange.dsx.dto.account.DSXAccountInfo;
import org.knowm.xchange.dsx.dto.account.DSXTransactionHistoryParams;
import org.knowm.xchange.dsx.dto.trade.DSXTransHistoryResult;
import org.knowm.xchange.dsx.service.DSXAccountServiceRaw;
import org.knowm.xchange.dsx.service.trade.params.DSXTransHistoryParams;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrency;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsIdSpan;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;
import org.knowm.xchange.utils.DateUtils;

public class DSXAccountService
extends DSXAccountServiceRaw
implements AccountService {
    public DSXAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        DSXAccountInfo info = this.getDSXAccountInfo();
        return new AccountInfo(new Wallet[]{DSXAdapters.adaptWallet(info)});
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        String c = currency.getCurrencyCode();
        boolean fiat = "EUR".equals(currency) || "USD".equals(currency) || "RUB".equals(currency);
        long transactionId = fiat ? this.withdrawFiat(c, amount) : this.withdrawCrypto(c, address, amount, null);
        this.submitWithdraw(transactionId);
        return Long.toString(transactionId);
    }

    public String withdrawFunds(WithdrawFundsParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        if (params instanceof DefaultWithdrawFundsParams) {
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            return this.withdrawFunds(defaultParams.currency, defaultParams.amount, defaultParams.address);
        }
        throw new IllegalStateException("Don't know how to withdraw: " + params);
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        return this.requestAddress(currency.toString(), Integer.parseInt(args[0]));
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new DSXTransactionHistoryParams();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        Currency c;
        Long count = null;
        Long since = null;
        Long end = null;
        Long fromId = null;
        Long toId = null;
        String currency = null;
        DSXTransHistoryResult.Status status = null;
        DSXTransHistoryResult.Type type = null;
        if (params instanceof TradeHistoryParamsTimeSpan) {
            TradeHistoryParamsTimeSpan timeSpan = (TradeHistoryParamsTimeSpan)params;
            since = DSXAccountService.nullSafeUnixTime(timeSpan.getStartTime());
            end = DSXAccountService.nullSafeUnixTime(timeSpan.getEndTime());
        }
        if (params instanceof TradeHistoryParamsIdSpan) {
            TradeHistoryParamsIdSpan idSpan = (TradeHistoryParamsIdSpan)params;
            fromId = DSXAccountService.nullSafeToLong(idSpan.getStartId());
            toId = DSXAccountService.nullSafeToLong(idSpan.getEndId());
        }
        if (params instanceof TradeHistoryParamCurrency) {
            c = ((TradeHistoryParamCurrency)params).getCurrency();
            String string = currency = c == null ? null : c.getCurrencyCode();
        }
        if (params instanceof DSXTransHistoryParams) {
            status = ((DSXTransHistoryParams)params).getStatus();
        }
        if (params instanceof TradeHistoryParamCurrency) {
            c = ((TradeHistoryParamCurrency)params).getCurrency();
            currency = c == null ? null : c.getCurrencyCode();
        }
        ArrayList<FundingRecord> result = new ArrayList<FundingRecord>();
        for (Map.Entry<Long, DSXTransHistoryResult> t : this.getDSXTransHistory(count, fromId, toId, null, since, end, type, status, currency).entrySet()) {
            result.add(new FundingRecord(t.getValue().getAddress(), new Date(t.getValue().getTimestamp() * 1000L), Currency.getInstance((String)t.getValue().getCurrency()), t.getValue().getAmount(), Long.toString(t.getValue().getId()), null, this.convert(t.getValue().getType()), this.convert(t.getValue().getStatus()), null, t.getValue().getCommission(), null));
        }
        return result;
    }

    private FundingRecord.Status convert(DSXTransHistoryResult.Status status) {
        switch (status) {
            case Completed: {
                return FundingRecord.Status.COMPLETE;
            }
            case Failed: {
                return FundingRecord.Status.FAILED;
            }
            case Processing: {
                return FundingRecord.Status.PROCESSING;
            }
            case Rejected: {
                return FundingRecord.Status.CANCELLED;
            }
        }
        throw new RuntimeException("Unknown DSX transaction status: " + (Object)((Object)status));
    }

    private FundingRecord.Type convert(DSXTransHistoryResult.Type type) {
        switch (type) {
            case Incoming: {
                return FundingRecord.Type.DEPOSIT;
            }
            case Withdraw: {
                return FundingRecord.Type.WITHDRAWAL;
            }
        }
        throw new RuntimeException("Unknown DSX transaction type: " + (Object)((Object)type));
    }

    private static Long nullSafeUnixTime(Date time) {
        return time != null ? Long.valueOf(DateUtils.toUnixTime((Date)time)) : null;
    }

    private static Long nullSafeToLong(String str) {
        try {
            return str == null || str.isEmpty() ? null : Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

