/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dsx.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.dsx.DSXAuthenticatedV2;
import org.knowm.xchange.dsx.dto.account.DSXAccountInfo;
import org.knowm.xchange.dsx.dto.account.DSXAccountInfoReturn;
import org.knowm.xchange.dsx.dto.account.DSXCryptoDepositAddress;
import org.knowm.xchange.dsx.dto.account.DSXCryptoDepositAddressReturn;
import org.knowm.xchange.dsx.dto.account.DSXCryptoWithdraw;
import org.knowm.xchange.dsx.dto.account.DSXCryptoWithdrawReturn;
import org.knowm.xchange.dsx.dto.account.DSXFiatWithdraw;
import org.knowm.xchange.dsx.dto.account.DSXFiatWithdrawReturn;
import org.knowm.xchange.dsx.dto.account.DSXTransaction;
import org.knowm.xchange.dsx.dto.account.DSXTransactionReturn;
import org.knowm.xchange.dsx.dto.trade.DSXTransHistoryResult;
import org.knowm.xchange.dsx.dto.trade.DSXTransHistoryReturn;
import org.knowm.xchange.dsx.service.DSXBaseService;
import si.mazi.rescu.SynchronizedValueFactory;

public class DSXAccountServiceRaw
extends DSXBaseService {
    public DSXAccountServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public DSXAccountInfo getDSXAccountInfo() throws IOException {
        DSXAccountInfoReturn info = this.dsx.getInfo(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        this.checkResult(info);
        return (DSXAccountInfo)info.getReturnValue();
    }

    public long withdrawCrypto(String currency, String address, BigDecimal amount, BigDecimal commission) throws IOException {
        DSXCryptoWithdrawReturn info = this.dsx.cryptoWithdraw(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency, address, amount, commission);
        this.checkResult(info);
        return ((DSXCryptoWithdraw)info.getReturnValue()).getTransactionId();
    }

    public long withdrawFiat(String currency, BigDecimal amount) throws IOException {
        DSXFiatWithdrawReturn info = this.dsx.fiatWithdraw(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency, amount);
        this.checkResult(info);
        return ((DSXFiatWithdraw)info.getReturnValue()).getTransactionId();
    }

    public DSXTransaction submitWithdraw(long transactionId) throws IOException {
        DSXTransactionReturn result = this.dsx.submitWithdraw(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), transactionId);
        this.checkResult(result);
        return (DSXTransaction)result.getReturnValue();
    }

    public DSXTransaction cancelWithdraw(long transactionId) throws IOException {
        DSXTransactionReturn result = this.dsx.cancelWithdraw(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), transactionId);
        this.checkResult(result);
        return (DSXTransaction)result.getReturnValue();
    }

    public String requestAddress(String currency, int newAddress) throws IOException {
        DSXCryptoDepositAddressReturn info = this.dsx.getCryptoDepositAddress(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency, newAddress);
        this.checkResult(info);
        return String.valueOf(((DSXCryptoDepositAddress)info.getReturnValue()).getAddress());
    }

    public Map<Long, DSXTransHistoryResult> getDSXTransHistory(Long to, Long fromId, Long toId, DSXAuthenticatedV2.SortOrder sortOrder, Long since, Long end, DSXTransHistoryResult.Type type, DSXTransHistoryResult.Status status, String currency) throws IOException {
        DSXTransHistoryReturn dsxTransHistory = this.dsx.TransHistory(this.apiKey, this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), to, fromId, toId, sortOrder, since, end, type, status, currency);
        this.checkResult(dsxTransHistory);
        return (Map)dsxTransHistory.getReturnValue();
    }
}

