/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dsx.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dsx.DSXAdapters;
import org.knowm.xchange.dsx.dto.marketdata.DSXOrderbookWrapper;
import org.knowm.xchange.dsx.dto.marketdata.DSXTickerWrapper;
import org.knowm.xchange.dsx.dto.marketdata.DSXTrade;
import org.knowm.xchange.dsx.service.DSXMarketDataServiceRaw;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class DSXMarketDataService
extends DSXMarketDataServiceRaw
implements MarketDataService {
    public DSXMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        String pairs = DSXAdapters.getPair(currencyPair);
        String accountType = null;
        try {
            accountType = (String)args[0];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        DSXTickerWrapper dsxTickerWrapper = this.getDSXTicker(pairs, accountType);
        return DSXAdapters.adaptTicker(dsxTickerWrapper.getTicker(DSXAdapters.getPair(currencyPair)), currencyPair);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        String pairs = DSXAdapters.getPair(currencyPair);
        String accountType = null;
        try {
            accountType = (String)args[0];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        DSXOrderbookWrapper dsxOrderbookWrapper = this.getDSXOrderbook(pairs, accountType);
        List<LimitOrder> asks = DSXAdapters.adaptOrders(dsxOrderbookWrapper.getOrderbook(DSXAdapters.getPair(currencyPair)).getAsks(), currencyPair, "ask", "");
        List<LimitOrder> bids = DSXAdapters.adaptOrders(dsxOrderbookWrapper.getOrderbook(DSXAdapters.getPair(currencyPair)).getBids(), currencyPair, "bid", "");
        return new OrderBook(null, asks, bids);
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        String pairs = DSXAdapters.getPair(currencyPair);
        int numberOfItems = -1;
        try {
            numberOfItems = (Integer)args[0];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        String accountType = null;
        try {
            accountType = (String)args[0];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        DSXTrade[] dsxTrades = numberOfItems == -1 ? this.getDSXTrades(pairs, 2000, accountType).getTrades(DSXAdapters.getPair(currencyPair)) : this.getDSXTrades(pairs, numberOfItems, accountType).getTrades(DSXAdapters.getPair(currencyPair));
        return DSXAdapters.adaptTrades(dsxTrades, currencyPair);
    }
}

