/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.client.serialization.model.VerificationSequenceDTO;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerificationSequenceSerializer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();

    public String serialize(VerificationSequence verificationSequence) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new VerificationSequenceDTO(verificationSequence));
        }
        catch (Exception e) {
            this.logger.error("Exception while serializing verificationSequence to JSON with value " + verificationSequence, (Throwable)e);
            throw new RuntimeException("Exception while serializing verificationSequence to JSON with value" + verificationSequence, e);
        }
    }

    public VerificationSequence deserialize(String jsonVerification) {
        VerificationSequence verificationSequence = null;
        if (jsonVerification != null && !jsonVerification.isEmpty()) {
            try {
                VerificationSequenceDTO verificationDTO = (VerificationSequenceDTO)this.objectMapper.readValue(jsonVerification, VerificationSequenceDTO.class);
                if (verificationDTO != null) {
                    verificationSequence = verificationDTO.buildObject();
                }
            }
            catch (Exception ioe) {
                this.logger.info("Exception while parsing response [" + jsonVerification + "] for verificationSequence", (Throwable)ioe);
                throw new RuntimeException("Exception while parsing response [" + jsonVerification + "] for verificationSequence", ioe);
            }
        }
        return verificationSequence;
    }
}

