/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.exception.WriteLockException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.owasp.dependencycheck.utils.WriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostedSuppressionsDataSource
implements CachedWebDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostedSuppressionsDataSource.class);
    private Settings settings;
    private DatabaseProperties dbProperties = null;
    public static final String DEFAULT_SUPPRESSIONS_URL = "https://jeremylong.github.io/DependencyCheck/suppressions/publishedSuppressions.xml";

    @Override
    public boolean update(Engine engine) throws UpdateException {
        this.settings = engine.getSettings();
        if (engine.getMode() != Engine.Mode.EVIDENCE_COLLECTION) {
            this.dbProperties = engine.getDatabase().getDatabaseProperties();
        }
        String configuredUrl = this.settings.getString("hosted.suppressions.url", DEFAULT_SUPPRESSIONS_URL);
        boolean autoupdate = this.settings.getBoolean("odc.autoupdate", true);
        boolean forceupdate = this.settings.getBoolean("hosted.suppressions.forceupdate", false);
        boolean cpeSuppressionEnabled = this.settings.getBoolean("analyzer.cpesuppression.enabled", true);
        boolean vulnSuppressionEnabled = this.settings.getBoolean("analyzer.vulnerabilitysuppression.enabled", true);
        boolean enabled = this.settings.getBoolean("hosted.suppressions.enabled", true);
        enabled = enabled && (cpeSuppressionEnabled || vulnSuppressionEnabled);
        try {
            boolean proceed;
            URL url = new URL(configuredUrl);
            File filepath = new File(url.getPath());
            File repoFile = new File(this.settings.getDataDirectory(), filepath.getName());
            boolean bl = proceed = enabled && (forceupdate || autoupdate && this.shouldUpdate(repoFile));
            if (proceed) {
                LOGGER.debug("Begin Hosted Suppressions file update");
                this.fetchHostedSuppressions(this.settings, url, repoFile);
                if (this.dbProperties != null) {
                    this.dbProperties.save("hosted.suppression.checked", Long.toString(System.currentTimeMillis() / 1000L));
                }
            }
        }
        catch (UpdateException ex) {
            LOGGER.warn("Failed to update hosted suppressions file, results may contain false positives already resolved by the DependencyCheck project", (Throwable)ex);
        }
        catch (MalformedURLException ex) {
            throw new UpdateException(String.format("Invalid URL for Hosted Suppressions file (%s)", configuredUrl), ex);
        }
        catch (IOException ex) {
            throw new UpdateException("Unable to get the data directory", ex);
        }
        return false;
    }

    protected boolean shouldUpdate(File repo) throws NumberFormatException {
        boolean proceed = true;
        if (repo != null && repo.isFile()) {
            int validForHours = this.settings.getInt("hosted.suppressions.validforhours", 2);
            long lastUpdatedOn = 0L;
            if (this.dbProperties != null) {
                lastUpdatedOn = this.dbProperties.getPropertyInSeconds("hosted.suppression.checked");
            }
            if (lastUpdatedOn <= 0L) {
                lastUpdatedOn = repo.lastModified();
            }
            long now = System.currentTimeMillis();
            LOGGER.debug("Last updated: {}", (Object)lastUpdatedOn);
            LOGGER.debug("Now: {}", (Object)now);
            long msValid = (long)validForHours * 60L * 60L * 1000L;
            boolean bl = proceed = now - lastUpdatedOn > msValid;
            if (!proceed) {
                LOGGER.info("Skipping Hosted Suppressions file update since last update was within {} hours.", (Object)validForHours);
            }
        }
        return proceed;
    }

    private void fetchHostedSuppressions(Settings settings, URL repoUrl, File repoFile) throws UpdateException {
        try (WriteLock ignored = new WriteLock(settings, true, repoFile.getName() + ".lock");){
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Hosted Suppressions URL: {}", (Object)repoUrl.toExternalForm());
            }
            Downloader downloader = new Downloader(settings);
            downloader.fetchFile(repoUrl, repoFile);
        }
        catch (IOException | WriteLockException | ResourceNotFoundException | TooManyRequestsException ex) {
            throw new UpdateException("Failed to update the hosted suppressions file", ex);
        }
    }

    @Override
    public boolean purge(Engine engine) {
        boolean result;
        block14: {
            this.settings = engine.getSettings();
            result = true;
            try {
                URL repoUrl = new URL(this.settings.getString("hosted.suppressions.url", DEFAULT_SUPPRESSIONS_URL));
                String filename = new File(repoUrl.getPath()).getName();
                File repo = new File(this.settings.getDataDirectory(), filename);
                if (!repo.exists()) break block14;
                try (WriteLock ignored = new WriteLock(this.settings, true, filename + ".lock");){
                    result = this.deleteCachedFile(repo);
                }
            }
            catch (IOException | WriteLockException ex) {
                LOGGER.error("Unable to delete the Hosted suppression file - invalid configuration");
                result = false;
            }
        }
        return result;
    }

    private boolean deleteCachedFile(File repo) {
        boolean deleted = true;
        try {
            Files.delete(repo.toPath());
            LOGGER.info("Hosted suppression file removed successfully");
        }
        catch (IOException ex) {
            LOGGER.error("Unable to delete '{}'; please delete the file manually", (Object)repo.getAbsolutePath(), (Object)ex);
            deleted = false;
        }
        return deleted;
    }
}

