/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd.api;

import io.github.jeremylong.openvulnerability.client.nvd.DefCveItem;
import java.io.File;
import java.util.concurrent.Callable;
import org.owasp.dependencycheck.data.nvd.ecosystem.CveEcosystemMapper;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.update.nvd.api.CveApiJson20CveItemSource;
import org.owasp.dependencycheck.data.update.nvd.api.CveItemSource;
import org.owasp.dependencycheck.data.update.nvd.api.JsonArrayCveItemSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvdApiProcessor
implements Callable<NvdApiProcessor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NvdApiProcessor.class);
    private final CveDB cveDB;
    private File jsonFile;
    private final CveEcosystemMapper mapper = new CveEcosystemMapper();
    private final long startTime;
    private long endTime = 0L;

    public NvdApiProcessor(CveDB cveDB, File jsonFile, long startTime) {
        this.cveDB = cveDB;
        this.jsonFile = jsonFile;
        this.startTime = startTime;
    }

    public NvdApiProcessor(CveDB cveDB, File jsonFile) {
        this(cveDB, jsonFile, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NvdApiProcessor call() throws Exception {
        block7: {
            CveItemSource<DefCveItem> itemSource = null;
            itemSource = this.jsonFile.getName().endsWith(".jsonarray.gz") ? new JsonArrayCveItemSource(this.jsonFile) : (this.jsonFile.getName().endsWith(".gz") ? new CveApiJson20CveItemSource(this.jsonFile) : new JsonArrayCveItemSource(this.jsonFile));
            block5: while (true) {
                while (itemSource.hasNext()) {
                    Object entry = itemSource.next();
                    try {
                        this.cveDB.updateVulnerability((DefCveItem)entry, this.mapper.getEcosystem((DefCveItem)entry));
                        continue block5;
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed to process " + entry.getCve().getId(), (Throwable)ex);
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                itemSource.close();
            }
        }
        this.endTime = System.currentTimeMillis();
        return this;
    }

    public long getDurationMillis() {
        return this.endTime - this.startTime;
    }
}

