/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util.attrs;

import java.util.List;
import java.util.Map;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Label;
import org.objectweb.asm.attrs.StackMapFrame;
import org.objectweb.asm.attrs.StackMapTableAttribute;
import org.objectweb.asm.attrs.StackMapType;
import org.objectweb.asm.util.attrs.ASMifiable;
import org.objectweb.asm.util.attrs.Traceable;

public class ASMStackMapTableAttribute
extends StackMapTableAttribute
implements ASMifiable,
Traceable {
    private int len;

    public ASMStackMapTableAttribute() {
    }

    public ASMStackMapTableAttribute(List list, int n) {
        super(list);
        this.len = n;
    }

    protected Attribute read(ClassReader classReader, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        StackMapTableAttribute stackMapTableAttribute = (StackMapTableAttribute)super.read(classReader, n, n2, cArray, n3, labelArray);
        return new ASMStackMapTableAttribute(stackMapTableAttribute.getFrames(), n2);
    }

    public void asmify(StringBuffer stringBuffer, String string, Map map) {
        List list = this.getFrames();
        if (list.size() == 0) {
            stringBuffer.append("List frames = Collections.EMPTY_LIST;\n");
        } else {
            stringBuffer.append("List frames = new ArrayList();\n");
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append("{\n");
                StackMapFrame stackMapFrame = (StackMapFrame)list.get(i);
                ASMStackMapTableAttribute.declareLabel(stringBuffer, map, stackMapFrame.label);
                String string2 = string + "frame" + i;
                this.asmifyTypeInfo(stringBuffer, string2, map, stackMapFrame.locals, "locals");
                this.asmifyTypeInfo(stringBuffer, string2, map, stackMapFrame.stack, "stack");
                stringBuffer.append("StackMapFrame ").append(string2).append(" = new StackMapFrame(").append(map.get(stackMapFrame.label)).append(", locals, stack);\n");
                stringBuffer.append("frames.add(").append(string2).append(");\n");
                stringBuffer.append("}\n");
            }
        }
        stringBuffer.append("StackMapTableAttribute ").append(string);
        stringBuffer.append(" = new StackMapTableAttribute(frames);\n");
    }

    void asmifyTypeInfo(StringBuffer stringBuffer, String string, Map map, List list, String string2) {
        if (list.size() == 0) {
            stringBuffer.append("List ").append(string2).append(" = Collections.EMPTY_LIST;\n");
        } else {
            stringBuffer.append("List ").append(string2).append(" = new ArrayList();\n");
            stringBuffer.append("{\n");
            for (int i = 0; i < list.size(); ++i) {
                StackMapType stackMapType = (StackMapType)list.get(i);
                String string3 = string + "Info" + i;
                int n = stackMapType.getType();
                stringBuffer.append("StackMapType ").append(string3).append(" = StackMapType.getTypeInfo( StackMapType.ITEM_").append(StackMapType.ITEM_NAMES[n]).append(");\n");
                switch (n) {
                    case 7: {
                        stringBuffer.append(string3).append(".setObject(\"").append(stackMapType.getObject()).append("\");\n");
                        break;
                    }
                    case 8: {
                        ASMStackMapTableAttribute.declareLabel(stringBuffer, map, stackMapType.getLabel());
                        stringBuffer.append(string3).append(".setLabel(").append(map.get(stackMapType.getLabel())).append(");\n");
                    }
                }
                stringBuffer.append(string2).append(".add(").append(string3).append(");\n");
            }
            stringBuffer.append("}\n");
        }
    }

    static void declareLabel(StringBuffer stringBuffer, Map map, Label label) {
        String string = (String)map.get(label);
        if (string == null) {
            string = "l" + map.size();
            map.put(label, string);
            stringBuffer.append("Label ").append(string).append(" = new Label();\n");
        }
    }

    public void trace(StringBuffer stringBuffer, Map map) {
        List list = this.getFrames();
        stringBuffer.append("[\n");
        for (int i = 0; i < list.size(); ++i) {
            StackMapFrame stackMapFrame = (StackMapFrame)list.get(i);
            stringBuffer.append("    Frame:");
            this.appendLabel(stringBuffer, map, stackMapFrame.label);
            stringBuffer.append(" locals[");
            this.traceTypeInfo(stringBuffer, map, stackMapFrame.locals);
            stringBuffer.append("]");
            stringBuffer.append(" stack[");
            this.traceTypeInfo(stringBuffer, map, stackMapFrame.stack);
            stringBuffer.append("]\n");
        }
        stringBuffer.append("  ] length:").append(this.len).append("\n");
    }

    private void traceTypeInfo(StringBuffer stringBuffer, Map map, List list) {
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            StackMapType stackMapType = (StackMapType)list.get(i);
            stringBuffer.append(string).append(StackMapType.ITEM_NAMES[stackMapType.getType()]);
            string = ", ";
            if (stackMapType.getType() == 7) {
                stringBuffer.append(":").append(stackMapType.getObject());
            }
            if (stackMapType.getType() != 8) continue;
            stringBuffer.append(":");
            this.appendLabel(stringBuffer, map, stackMapType.getLabel());
        }
    }

    protected void appendLabel(StringBuffer stringBuffer, Map map, Label label) {
        String string = (String)map.get(label);
        if (string == null) {
            string = "L" + map.size();
            map.put(label, string);
        }
        stringBuffer.append(string);
    }
}

