/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.lafwidget.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.pushingpixels.lafwidget.ant.AugmentException;
import org.pushingpixels.lafwidget.ant.InfoClassVisitor;
import org.pushingpixels.lafwidget.ant.Utils;

public class UiDelegateAugmenter {
    private Set<String> methodsToChange = new HashSet<String>();
    private boolean isVerbose;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void augmentClass(String dir, String name) {
        byte[] b;
        if (this.isVerbose) {
            System.out.println("Working on " + name);
        }
        String resource = String.valueOf(dir) + File.separator + name.replace('.', '/') + ".class";
        HashMap<String, Method> methodsToAugment = new HashMap<String, Method>();
        try {
            URLClassLoader cl = new URLClassLoader(new URL[]{new File(dir).toURL()}, UiDelegateAugmenter.class.getClassLoader());
            Class<?> clazz = cl.loadClass(name);
            if (!ComponentUI.class.isAssignableFrom(clazz)) {
                if (!this.isVerbose) return;
                System.out.println("Not augmenting resource, doesn't extend ComponentUI");
                return;
            }
            block31: while (clazz != null) {
                Method[] methods = clazz.getDeclaredMethods();
                int i = 0;
                while (true) {
                    if (i >= methods.length) {
                        clazz = clazz.getSuperclass();
                        continue block31;
                    }
                    Method method = methods[i];
                    if (!methodsToAugment.containsKey(method.getName()) && this.methodsToChange.contains(method.getName())) {
                        boolean isSupportedRetType = Void.TYPE == method.getReturnType();
                        Class<?>[] paramTypes = method.getParameterTypes();
                        boolean isSupportedParamList = paramTypes.length == 0 || paramTypes.length == 1 && JComponent.class.isAssignableFrom(paramTypes[0]);
                        if (!isSupportedRetType) throw new AugmentException("Method '" + method.getName() + "' in class '" + name + "' has unsupported signature");
                        if (!isSupportedParamList) throw new AugmentException("Method '" + method.getName() + "' in class '" + name + "' has unsupported signature");
                        if (Modifier.isProtected(method.getModifiers()) || Modifier.isPublic(method.getModifiers())) {
                            methodsToAugment.put(method.getName(), method);
                        } else if (this.isVerbose) {
                            System.out.println("Not augmenting private " + name + "." + method.getName());
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new AugmentException(name, e);
        }
        Set<String> existingMethods = null;
        Set<String> existingFields = null;
        InputStream is = null;
        try {
            try {
                is = new FileInputStream(resource);
                ClassReader cr = new ClassReader(is);
                InfoClassVisitor infoAdapter = new InfoClassVisitor();
                cr.accept(infoAdapter, false);
                existingMethods = infoAdapter.getMethods();
                existingFields = infoAdapter.getFields();
            }
            catch (Exception e) {
                throw new AugmentException(name, e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException paramTypes) {}
        }
        if (existingFields.contains("lafWidgets")) {
            if (!this.isVerbose) return;
            System.out.println("Not augmenting resource, field 'lafWidgets' is present");
            return;
        }
        try {
            try {
                is = new FileInputStream(resource);
                ClassReader cr = new ClassReader(is);
                ClassWriter cw = new ClassWriter(false);
                AugmentClassAdapter cv = new AugmentClassAdapter(cw, existingMethods, existingFields, methodsToAugment);
                cr.accept(cv, false);
                b = cw.toByteArray();
            }
            catch (Exception e) {
                throw new AugmentException(name, e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(resource);
                fos.write(b);
                if (!this.isVerbose) return;
                System.out.println("Updated resource " + resource);
                return;
            }
            catch (Exception exception) {
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public UiDelegateAugmenter() {
        this.methodsToChange.add("installUI");
        this.methodsToChange.add("installDefaults");
        this.methodsToChange.add("installComponents");
        this.methodsToChange.add("installListeners");
        this.methodsToChange.add("uninstallUI");
        this.methodsToChange.add("uninstallDefaults");
        this.methodsToChange.add("uninstallComponents");
        this.methodsToChange.add("uninstallListeners");
    }

    public void process(String toStrip, File file, Pattern pattern) throws AugmentException {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.process(toStrip, children[i], pattern);
                ++i;
            }
        } else {
            Matcher m = pattern.matcher(file.getName());
            if (m.matches()) {
                String className = file.getAbsolutePath().substring(toStrip.length() + 1);
                className = className.replace(File.separatorChar, '.');
                this.augmentClass(toStrip, className.substring(0, className.length() - 6));
            }
        }
    }

    public void setVerbose(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    public static void main(String[] args) throws AugmentException {
        if (args.length == 0) {
            System.out.println("Usage : java ... UiDelegateAugmenter [-verbose] [-pattern class_pattern] file_resource");
            System.out.println("\tIf -verbose option is specified, the augmenter prints out its actions.");
            System.out.println("\tIf -pattern option is specified, its value is used as a wildcard for matching the classes for augmentation.");
            System.out.println("\tThe last parameter can point to either a file or a directory. The directory should be the root directory for classes.");
            return;
        }
        UiDelegateAugmenter uiDelegateAugmenter = new UiDelegateAugmenter();
        int argNum = 0;
        String pattern = ".*UI.class";
        while (true) {
            String currArg;
            if ("-verbose".equals(currArg = args[argNum])) {
                uiDelegateAugmenter.setVerbose(true);
                ++argNum;
                continue;
            }
            if (!"-pattern".equals(currArg)) break;
            pattern = args[++argNum];
            ++argNum;
        }
        Pattern p = Pattern.compile(pattern);
        File starter = new File(args[argNum]);
        uiDelegateAugmenter.process(starter.getAbsolutePath(), starter, p);
    }

    protected class AugmentClassAdapter
    extends ClassAdapter
    implements Opcodes {
        private Set<String> existingMethods;
        private Set<String> existingFields;
        private Map<String, Method> methodsToAugment;
        private String prefix;

        public AugmentClassAdapter(ClassVisitor cv, Set<String> existingMethods, Set<String> existingFields, Map<String, Method> methodsToAugment) {
            super(cv);
            this.existingMethods = existingMethods;
            this.existingFields = existingFields;
            this.methodsToAugment = methodsToAugment;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.prefix = "__" + name.replaceAll("/", "__") + "__";
            super.visit(version, access, name, signature, superName, interfaces);
            if (!this.existingFields.contains("lafWidgets")) {
                FieldVisitor fv = this.visitField(4, "lafWidgets", "Ljava/util/Set;", null, null);
                fv.visitEnd();
            }
            for (String methodName : UiDelegateAugmenter.this.methodsToChange) {
                if (!this.methodsToAugment.containsKey(methodName)) continue;
                boolean hasOriginal = this.existingMethods.contains(methodName);
                boolean hasDelegate = this.existingMethods.contains(String.valueOf(this.prefix) + methodName);
                Method method = this.methodsToAugment.get(methodName);
                String methodSignature = Utils.getMethodDesc(method);
                int paramCount = method.getParameterTypes().length;
                if (UiDelegateAugmenter.this.isVerbose) {
                    System.out.println("... Augmenting " + methodName + " " + methodSignature + " : original - " + hasOriginal + ", delegate - " + hasDelegate + ", " + paramCount + " params");
                }
                if (hasDelegate) continue;
                if (methodName.equals("installUI")) {
                    this.augmentInstallUIMethod(!hasOriginal, name, superName, methodSignature);
                    continue;
                }
                if (method.getParameterTypes().length == 0) {
                    this.augmentVoidMethod(!hasOriginal, name, superName, methodName, method.getModifiers());
                    continue;
                }
                this.augmentSingleParameterMethod(!hasOriginal, name, superName, methodName, method.getModifiers(), methodSignature);
            }
        }

        public void augmentVoidMethod(boolean toSynthOriginal, String className, String superClassName, String methodName, int methodModifiers) {
            MethodVisitor mv;
            int modifierOpcode = 1;
            if (Modifier.isProtected(methodModifiers)) {
                modifierOpcode = 4;
            }
            if (toSynthOriginal) {
                mv = this.cv.visitMethod(modifierOpcode, String.valueOf(this.prefix) + methodName, "()V", null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(183, superClassName, methodName, "()V");
                mv.visitInsn(177);
                mv.visitMaxs(1, 1);
                mv.visitEnd();
            }
            mv = this.cv.visitMethod(modifierOpcode, methodName, "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, className, String.valueOf(this.prefix) + methodName, "()V");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, "lafWidgets", "Ljava/util/Set;");
            mv.visitMethodInsn(185, "java/util/Set", "iterator", "()Ljava/util/Iterator;");
            mv.visitVarInsn(58, 1);
            Label l0 = new Label();
            mv.visitJumpInsn(167, l0);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;");
            mv.visitTypeInsn(192, "org/pushingpixels/lafwidget/LafWidget");
            mv.visitVarInsn(58, 2);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(185, "org/pushingpixels/lafwidget/LafWidget", methodName, "()V");
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z");
            mv.visitJumpInsn(154, l1);
            mv.visitInsn(177);
            mv.visitMaxs(1, 3);
            mv.visitEnd();
        }

        public void augmentSingleParameterMethod(boolean toSynthOriginal, String className, String superClassName, String methodName, int methodModifiers, String functionDesc) {
            MethodVisitor mv;
            int modifierOpcode = 1;
            if (Modifier.isProtected(methodModifiers)) {
                modifierOpcode = 4;
            }
            if (toSynthOriginal) {
                if (UiDelegateAugmenter.this.isVerbose) {
                    System.out.println("... Creating empty '" + methodName + functionDesc + "' forwarding to super '" + superClassName + "'");
                }
                mv = this.cv.visitMethod(modifierOpcode, String.valueOf(this.prefix) + methodName, functionDesc, null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(183, superClassName, methodName, functionDesc);
                mv.visitInsn(177);
                mv.visitMaxs(2, 2);
                mv.visitEnd();
            }
            if (UiDelegateAugmenter.this.isVerbose) {
                System.out.println("... Augmenting '" + methodName + functionDesc + "'");
            }
            mv = this.cv.visitMethod(modifierOpcode, methodName, functionDesc, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, className, String.valueOf(this.prefix) + methodName, functionDesc);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, "lafWidgets", "Ljava/util/Set;");
            mv.visitMethodInsn(185, "java/util/Set", "iterator", "()Ljava/util/Iterator;");
            mv.visitVarInsn(58, 2);
            Label l0 = new Label();
            mv.visitJumpInsn(167, l0);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;");
            mv.visitTypeInsn(192, "org/pushingpixels/lafwidget/LafWidget");
            mv.visitVarInsn(58, 3);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(185, "org/pushingpixels/lafwidget/LafWidget", methodName, "()V");
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z");
            mv.visitJumpInsn(154, l1);
            mv.visitInsn(177);
            mv.visitMaxs(2, 4);
            mv.visitEnd();
        }

        public void augmentInstallUIMethod(boolean toSynthOriginal, String className, String superClassName, String functionDesc) {
            MethodVisitor mv;
            if (toSynthOriginal) {
                mv = this.cv.visitMethod(1, String.valueOf(this.prefix) + "installUI", "(Ljavax/swing/JComponent;)V", null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(183, superClassName, "installUI", "(Ljavax/swing/JComponent;)V");
                mv.visitInsn(177);
                mv.visitMaxs(2, 2);
                mv.visitEnd();
            }
            mv = this.cv.visitMethod(1, "installUI", "(Ljavax/swing/JComponent;)V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "org/pushingpixels/lafwidget/LafWidgetRepository", "getRepository", "()Lorg/pushingpixels/lafwidget/LafWidgetRepository;");
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, "org/pushingpixels/lafwidget/LafWidgetRepository", "getMatchingWidgets", "(Ljavax/swing/JComponent;)Ljava/util/Set;");
            mv.visitFieldInsn(181, className, "lafWidgets", "Ljava/util/Set;");
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, className, String.valueOf(this.prefix) + "installUI", "(Ljavax/swing/JComponent;)V");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, "lafWidgets", "Ljava/util/Set;");
            mv.visitMethodInsn(185, "java/util/Set", "iterator", "()Ljava/util/Iterator;");
            mv.visitVarInsn(58, 2);
            Label l0 = new Label();
            mv.visitJumpInsn(167, l0);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;");
            mv.visitTypeInsn(192, "org/pushingpixels/lafwidget/LafWidget");
            mv.visitVarInsn(58, 3);
            mv.visitVarInsn(25, 3);
            mv.visitMethodInsn(185, "org/pushingpixels/lafwidget/LafWidget", "installUI", "()V");
            mv.visitLabel(l0);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z");
            mv.visitJumpInsn(154, l1);
            mv.visitInsn(177);
            mv.visitMaxs(3, 4);
            mv.visitEnd();
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (UiDelegateAugmenter.this.methodsToChange.contains(name) && !this.existingMethods.contains(String.valueOf(this.prefix) + name)) {
                if (UiDelegateAugmenter.this.isVerbose) {
                    System.out.println("... renaming '" + name + "(" + desc + ")' to '" + this.prefix + name + "'");
                }
                return this.cv.visitMethod(access, String.valueOf(this.prefix) + name, desc, signature, exceptions);
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

