/*
 * Decompiled with CFR 0.152.
 */
package test.check;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.TitledBorder;

public class TwoColumnPanel
extends JPanel {
    private ArrayList rows = new ArrayList();
    private TwoColumnLayout layout = new TwoColumnLayout();

    public TwoColumnPanel() {
        this.setLayout(this.layout);
    }

    public void addRow(Component left, Component right) {
        if (left == null && right == null) {
            return;
        }
        ComponentRow newRow = new ComponentRow(left, right);
        if (left != null) {
            this.add(left);
        }
        if (right != null) {
            this.add(right);
        }
        this.rows.add(newRow);
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        this.layout.setHorizontalSpacing(horizontalSpacing);
    }

    public void setMinimumLeftWidth(int minimumLeftWidth) {
        this.layout.setMinimumLeftWidth(minimumLeftWidth);
    }

    public void setMinimumRightWidth(int minimumRightWidth) {
        this.layout.setMinimumRightWidth(minimumRightWidth);
    }

    public void setVerticalSpacing(int verticalSpacing) {
        this.layout.setVerticalSpacing(verticalSpacing);
    }

    public static void main(String[] args) {
        TwoColumnPanel panel = new TwoColumnPanel();
        JPasswordField jpf1 = new JPasswordField("password", 10);
        panel.addRow(new JLabel("Enabled"), jpf1);
        JPasswordField jpf2 = new JPasswordField("password", 10);
        jpf2.setEditable(false);
        panel.addRow(new JLabel("Non-editable"), jpf2);
        JPasswordField jpf3 = new JPasswordField("password", 10);
        jpf3.setEnabled(false);
        panel.addRow(new JLabel("Disabled"), jpf3);
        JPasswordField jpf4 = new JPasswordField("password", 10);
        jpf4.setEchoChar('\u0000');
        panel.addRow(new JLabel("Echo char 0"), jpf4);
        JPasswordField jpf5 = new JPasswordField("password", 10);
        panel.addRow(new JLabel("With strength check"), jpf5);
        panel.setBorder(new TitledBorder("Password field"));
        JFrame frame = new JFrame();
        frame.setLayout(new BorderLayout());
        frame.add((Component)panel, "Center");
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 300);
        frame.setLocation(300, 300);
        frame.setVisible(true);
    }

    private static class ComponentRow {
        public Component left;
        public Component right;

        public ComponentRow(Component left, Component right) {
            this.left = left;
            this.right = right;
        }
    }

    private class TwoColumnLayout
    implements LayoutManager {
        private int verticalSpacing = 3;
        private int horizontalSpacing = 3;
        private int minimumLeftWidth = 0;
        private int minimumRightWidth = 0;

        public int getHorizontalSpacing() {
            return this.horizontalSpacing;
        }

        public void setHorizontalSpacing(int horizontalSpacing) {
            this.horizontalSpacing = horizontalSpacing;
        }

        public int getMinimumLeftWidth() {
            return this.minimumLeftWidth;
        }

        public void setMinimumLeftWidth(int minimumLeftWidth) {
            this.minimumLeftWidth = minimumLeftWidth;
        }

        public int getMinimumRightWidth() {
            return this.minimumRightWidth;
        }

        public void setMinimumRightWidth(int minimumRightWidth) {
            this.minimumRightWidth = minimumRightWidth;
        }

        public int getVerticalSpacing() {
            return this.verticalSpacing;
        }

        public void setVerticalSpacing(int verticalSpacing) {
            this.verticalSpacing = verticalSpacing;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int y = this.horizontalSpacing + insets.top;
            int leftPref = this.getPreferredLeftWidth();
            int rightPref = this.getPreferredRightWidth();
            double coef = (double)(parent.getWidth() - insets.left - insets.right - 3 * this.verticalSpacing) / (double)(leftPref + rightPref);
            int leftFinal = (int)(coef * (double)leftPref);
            int rightFinal = (int)(coef * (double)rightPref);
            int leftStart = insets.left + this.verticalSpacing;
            int rightStart = leftStart + leftFinal + this.verticalSpacing;
            for (ComponentRow row : TwoColumnPanel.this.rows) {
                Component left = row.left;
                int hLeft = row.left == null ? 0 : left.getPreferredSize().height;
                Component right = row.right;
                int hRight = row.right == null ? 0 : right.getPreferredSize().height;
                int h = Math.max(hLeft, hRight);
                if (left != null) {
                    left.setBounds(leftStart, y + (h - hLeft) / 2, leftFinal, hLeft);
                }
                if (right != null) {
                    right.setBounds(rightStart, y + (h - hRight) / 2, rightFinal, hRight);
                }
                y += this.horizontalSpacing + Math.max(hLeft, hRight);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int width = 3 * this.verticalSpacing + this.getPreferredLeftWidth() + this.getPreferredRightWidth();
            int height = this.horizontalSpacing;
            for (ComponentRow row : TwoColumnPanel.this.rows) {
                int hLeft = row.left == null ? 0 : row.left.getPreferredSize().height;
                int hRight = row.right == null ? 0 : row.right.getPreferredSize().height;
                height += this.horizontalSpacing + Math.max(hLeft, hRight);
            }
            return new Dimension(width, height);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        private int getPreferredLeftWidth() {
            int maxPreferredWidth = 0;
            for (ComponentRow row : TwoColumnPanel.this.rows) {
                if (row.left == null) continue;
                maxPreferredWidth = Math.max(maxPreferredWidth, row.left.getPreferredSize().width);
            }
            return Math.max(maxPreferredWidth, this.minimumLeftWidth);
        }

        private int getPreferredRightWidth() {
            int maxPreferredWidth = 0;
            for (ComponentRow row : TwoColumnPanel.this.rows) {
                if (row.right == null) continue;
                maxPreferredWidth = Math.max(maxPreferredWidth, row.right.getPreferredSize().width);
            }
            return Math.max(maxPreferredWidth, this.minimumRightWidth);
        }
    }
}

