/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.junit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.scalatest.Reporter;
import org.scalatest.Resources$;
import org.scalatest.ScalaTestStatefulStatus;
import org.scalatest.Suite$;
import org.scalatest.Tracker;
import org.scalatest.events.Formatter;
import org.scalatest.events.IndentedText;
import org.scalatest.events.Location;
import org.scalatest.events.MotionToSuppress$;
import org.scalatest.events.RecordableEvent;
import org.scalatest.events.SeeStackDepthException$;
import org.scalatest.events.TestFailed;
import org.scalatest.events.TestFailed$;
import org.scalatest.events.TestIgnored;
import org.scalatest.events.TestIgnored$;
import org.scalatest.events.TestStarting;
import org.scalatest.events.TestStarting$;
import org.scalatest.events.TestSucceeded;
import org.scalatest.events.TestSucceeded$;
import org.scalatest.events.TopOfMethod;
import org.scalatest.exceptions.PayloadField;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb!B\u0001\u0003\u0001\tA!!D'z%VtG*[:uK:,'O\u0003\u0002\u0004\t\u0005)!.\u001e8ji*\u0011QAB\u0001\ng\u000e\fG.\u0019;fgRT\u0011aB\u0001\u0004_J<7C\u0001\u0001\n!\tQ\u0001#D\u0001\f\u0015\taQ\"\u0001\u0007o_RLg-[2bi&|gN\u0003\u0002\u000f\u001f\u00051!/\u001e8oKJT!a\u0001\u0004\n\u0005EY!a\u0003*v]2K7\u000f^3oKJD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I!F\u0001\u0007e\u0016\u0004xN\u001d;\u0004\u0001A\u0011acF\u0007\u0002\t%\u0011\u0001\u0004\u0002\u0002\t%\u0016\u0004xN\u001d;fe\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\u0004d_:4\u0017n\u001a\t\u00059\u0015B3F\u0004\u0002\u001eGA\u0011a$I\u0007\u0002?)\u0011\u0001\u0005F\u0001\u0007yI|w\u000e\u001e \u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0002\rA\u0013X\rZ3g\u0013\t1sEA\u0002NCBT!\u0001J\u0011\u0011\u0005qI\u0013B\u0001\u0016(\u0005\u0019\u0019FO]5oOB\u0011A&L\u0007\u0002C%\u0011a&\t\u0002\u0004\u0003:L\b\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u0015QDW\r\u0016:bG.,'\u000f\u0005\u0002\u0017e%\u00111\u0007\u0002\u0002\b)J\f7m[3s\u0011!)\u0004A!A!\u0002\u00131\u0014AB:uCR,8\u000f\u0005\u0002\u0017o%\u0011\u0001\b\u0002\u0002\u0018'\u000e\fG.\u0019+fgR\u001cF/\u0019;fMVd7\u000b^1ukNDQA\u000f\u0001\u0005\u0002m\na\u0001P5oSRtD#\u0002\u001f?\u007f\u0001\u000b\u0005CA\u001f\u0001\u001b\u0005\u0011\u0001\"B\n:\u0001\u0004)\u0002\"\u0002\u000e:\u0001\u0004Y\u0002\"\u0002\u0019:\u0001\u0004\t\u0004\"B\u001b:\u0001\u00041\u0004bB\"\u0001\u0005\u0004%\t\u0001R\u0001\fM\u0006LG.\u001a3UKN$8/F\u0001F!\r15\nK\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0005kRLGNC\u0001K\u0003\u0011Q\u0017M^1\n\u00051;%aA*fi\"1a\n\u0001Q\u0001\n\u0015\u000bABZ1jY\u0016$G+Z:ug\u0002BQ\u0001\u0015\u0001\u0005\u0002E\u000babZ3u)>\u0004xJZ'fi\"|G\rF\u0002S7v\u00032\u0001L*V\u0013\t!\u0016E\u0001\u0003T_6,\u0007C\u0001,Z\u001b\u00059&B\u0001-\u0005\u0003\u0019)g/\u001a8ug&\u0011!l\u0016\u0002\f)>\u0004xJZ'fi\"|G\rC\u0003]\u001f\u0002\u0007\u0001&A\u0005dY\u0006\u001c8OT1nK\")al\u0014a\u0001Q\u0005QQ.\u001a;i_\u0012t\u0015-\\3\t\u000b\u0001\u0004A\u0011I1\u0002\u0017Q,7\u000f\u001e$bS2,(/\u001a\u000b\u0003E\u0016\u0004\"\u0001L2\n\u0005\u0011\f#\u0001B+oSRDQAZ0A\u0002\u001d\fqAZ1jYV\u0014X\r\u0005\u0002\u000bQ&\u0011\u0011n\u0003\u0002\b\r\u0006LG.\u001e:f\u0011\u0015Y\u0007\u0001\"\u0011m\u00031!Xm\u001d;GS:L7\u000f[3e)\t\u0011W\u000eC\u0003oU\u0002\u0007q.A\u0006eKN\u001c'/\u001b9uS>t\u0007C\u00019r\u001b\u0005i\u0011B\u0001:\u000e\u0005-!Um]2sSB$\u0018n\u001c8\t\u000bQ\u0004A\u0011I;\u0002\u0017Q,7\u000f^%h]>\u0014X\r\u001a\u000b\u0003EZDQA\\:A\u0002=DQ\u0001\u001f\u0001\u0005Be\fq\u0002^3tiJ+hNR5oSNDW\r\u001a\u000b\u0003EjDQa_<A\u0002q\faA]3tk2$\bC\u00019~\u0013\tqXB\u0001\u0004SKN,H\u000e\u001e\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u00039!Xm\u001d;Sk:\u001cF/\u0019:uK\u0012$2AYA\u0003\u0011\u0015qw\u00101\u0001p\u0011\u001d\tI\u0001\u0001C!\u0003\u0017\t1\u0002^3tiN#\u0018M\u001d;fIR\u0019!-!\u0004\t\r9\f9\u00011\u0001p\u0011%\t\t\u0002\u0001b\u0001\n\u0003\t\u0019\"\u0001\rU\u000bN#v\fR#T\u0007JK\u0005\u000bV%P\u001d~\u0003\u0016\t\u0016+F%:+\"!!\u0006\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007H\u0003\u0015\u0011XmZ3y\u0013\u0011\ty\"!\u0007\u0003\u000fA\u000bG\u000f^3s]\"A\u00111\u0005\u0001!\u0002\u0013\t)\"A\rU\u000bN#v\fR#T\u0007JK\u0005\u000bV%P\u001d~\u0003\u0016\t\u0016+F%:\u0003\u0003bBA\u0014\u0001\u0011%\u0011\u0011F\u0001\u0015a\u0006\u00148/\u001a+fgR$Um]2sSB$\u0018n\u001c8\u0015\t\u0005-\u0012\u0011\u0007\t\u0007Y\u00055\u0002\u0006\u000b\u0015\n\u0007\u0005=\u0012E\u0001\u0004UkBdWm\r\u0005\u0007]\u0006\u0015\u0002\u0019A8")
public class MyRunListener
extends RunListener {
    private final Reporter report;
    private final Tracker theTracker;
    private final ScalaTestStatefulStatus status;
    private final Set<String> failedTests;
    private final Pattern TEST_DESCRIPTION_PATTERN;

    public Set<String> failedTests() {
        return this.failedTests;
    }

    public Some<TopOfMethod> getTopOfMethod(String className, String methodName) {
        return new Some((Object)new TopOfMethod(className, "public void " + className + "." + methodName + "()"));
    }

    public void testFailure(Failure failure) {
        Option<Object> option;
        this.failedTests().add(failure.getDescription().getDisplayName());
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(failure.getDescription());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String testName = (String)tuple3._1();
        String testClass = (String)tuple3._2();
        String testClassName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
        Tuple3 tuple33 = tuple32;
        String testName2 = (String)tuple33._1();
        String testClass2 = (String)tuple33._2();
        String testClassName2 = (String)tuple33._3();
        Throwable throwableOrNull = failure.getException();
        None$ throwable = throwableOrNull != null ? new Some((Object)throwableOrNull) : None$.MODULE$;
        String message = throwableOrNull != null ? throwableOrNull.toString() : Resources$.MODULE$.jUnitTestFailed();
        IndentedText formatter = Suite$.MODULE$.getIndentedTextForTest(testName2, 1, true);
        None$ none$ = throwable;
        if (none$ instanceof PayloadField) {
            None$ none$2 = none$;
            option = ((PayloadField)none$2).payload();
        } else {
            option = None$.MODULE$;
        }
        Option<Object> payload = option;
        this.report.apply(new TestFailed(this.theTracker.nextOrdinal(), message, testClassName2, testClass2, (Option<String>)new Some((Object)testClass2), testName2, testName2, (IndexedSeq<RecordableEvent>)package$.MODULE$.Vector().empty(), (Option<Throwable>)throwable, (Option<Object>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Location>)new Some((Object)SeeStackDepthException$.MODULE$), (Option<String>)None$.MODULE$, payload, TestFailed$.MODULE$.apply$default$15(), TestFailed$.MODULE$.apply$default$16()));
    }

    public void testFinished(Description description) {
        if (!this.failedTests().contains(description.getDisplayName())) {
            Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            String testName = (String)tuple3._1();
            String testClass = (String)tuple3._2();
            String testClassName = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
            Tuple3 tuple33 = tuple32;
            String testName2 = (String)tuple33._1();
            String testClass2 = (String)tuple33._2();
            String testClassName2 = (String)tuple33._3();
            IndentedText formatter = Suite$.MODULE$.getIndentedTextForTest(testName2, 1, true);
            this.report.apply(new TestSucceeded(this.theTracker.nextOrdinal(), testClassName2, testClass2, (Option<String>)new Some((Object)testClass2), testName2, testName2, (IndexedSeq<RecordableEvent>)package$.MODULE$.Vector().empty(), (Option<Object>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Location>)this.getTopOfMethod(testClass2, testName2), TestSucceeded$.MODULE$.apply$default$11(), TestSucceeded$.MODULE$.apply$default$12(), TestSucceeded$.MODULE$.apply$default$13(), TestSucceeded$.MODULE$.apply$default$14()));
        } else {
            this.status.setFailed();
        }
    }

    public void testIgnored(Description description) {
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String testName = (String)tuple3._1();
        String testClass = (String)tuple3._2();
        String testClassName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
        Tuple3 tuple33 = tuple32;
        String testName2 = (String)tuple33._1();
        String testClass2 = (String)tuple33._2();
        String testClassName2 = (String)tuple33._3();
        IndentedText formatter = Suite$.MODULE$.getIndentedTextForTest(testName2, 1, true);
        this.report.apply(new TestIgnored(this.theTracker.nextOrdinal(), testClassName2, testClass2, (Option<String>)new Some((Object)testClass2), testName2, testName2, (Option<Formatter>)new Some((Object)formatter), (Option<Location>)this.getTopOfMethod(testClass2, testName2), TestIgnored$.MODULE$.apply$default$9(), TestIgnored$.MODULE$.apply$default$10(), TestIgnored$.MODULE$.apply$default$11()));
    }

    public void testRunFinished(Result result) {
    }

    public void testRunStarted(Description description) {
    }

    public void testStarted(Description description) {
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String testName = (String)tuple3._1();
        String testClass = (String)tuple3._2();
        String testClassName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
        Tuple3 tuple33 = tuple32;
        String testName2 = (String)tuple33._1();
        String testClass2 = (String)tuple33._2();
        String testClassName2 = (String)tuple33._3();
        this.report.apply(new TestStarting(this.theTracker.nextOrdinal(), testClassName2, testClass2, (Option<String>)new Some((Object)testClass2), testName2, testName2, (Option<Formatter>)new Some((Object)MotionToSuppress$.MODULE$), (Option<Location>)this.getTopOfMethod(testClass2, testName2), TestStarting$.MODULE$.apply$default$9(), TestStarting$.MODULE$.apply$default$10(), TestStarting$.MODULE$.apply$default$11(), TestStarting$.MODULE$.apply$default$12()));
    }

    public Pattern TEST_DESCRIPTION_PATTERN() {
        return this.TEST_DESCRIPTION_PATTERN;
    }

    private Tuple3<String, String, String> parseTestDescription(Description description) {
        Matcher matcher = this.TEST_DESCRIPTION_PATTERN().matcher(description.getDisplayName());
        if (!matcher.find()) {
            throw new RuntimeException("unexpected displayName [" + description.getDisplayName() + "]");
        }
        String testName = matcher.group(1);
        String testClass = matcher.group(2);
        String testClassName = testClass.replaceAll(".*\\.", "");
        return new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
    }

    public MyRunListener(Reporter report, Map<String, Object> config, Tracker theTracker, ScalaTestStatefulStatus status) {
        this.report = report;
        this.theTracker = theTracker;
        this.status = status;
        this.failedTests = Collections.synchronizedSet(new HashSet());
        this.TEST_DESCRIPTION_PATTERN = Pattern.compile("^(.*)\\((.*)\\)");
    }
}

