/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.support;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.util.Assert;
import org.springframework.web.method.support.UriComponentsContributor;
import org.springframework.web.util.UriComponentsBuilder;

public class CompositeUriComponentsContributor
implements UriComponentsContributor {
    private final List<UriComponentsContributor> contributors = new LinkedList<UriComponentsContributor>();
    private final ConversionService conversionService;

    public CompositeUriComponentsContributor(UriComponentsContributor ... contributors) {
        Collections.addAll(this.contributors, contributors);
        this.conversionService = new DefaultFormattingConversionService();
    }

    public CompositeUriComponentsContributor(Collection<?> contributors) {
        this(contributors, null);
    }

    public CompositeUriComponentsContributor(Collection<?> contributors, ConversionService conversionService) {
        Assert.notNull(contributors, (String)"'uriComponentsContributors' must not be null");
        for (Object contributor : contributors) {
            if (!(contributor instanceof UriComponentsContributor)) continue;
            this.contributors.add((UriComponentsContributor)contributor);
        }
        this.conversionService = conversionService != null ? conversionService : new DefaultFormattingConversionService();
    }

    public boolean hasContributors() {
        return this.contributors.isEmpty();
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        for (UriComponentsContributor contributor : this.contributors) {
            if (!contributor.supportsParameter(parameter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void contributeMethodArgument(MethodParameter parameter, Object value, UriComponentsBuilder builder, Map<String, Object> uriVariables, ConversionService conversionService) {
        for (UriComponentsContributor contributor : this.contributors) {
            if (!contributor.supportsParameter(parameter)) continue;
            contributor.contributeMethodArgument(parameter, value, builder, uriVariables, conversionService);
            break;
        }
    }

    public void contributeMethodArgument(MethodParameter parameter, Object value, UriComponentsBuilder builder, Map<String, Object> uriVariables) {
        this.contributeMethodArgument(parameter, value, builder, uriVariables, this.conversionService);
    }
}

