/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.host;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;

public class ServletBuilder {
    private Class<?> servletClass;
    private Servlet servlet;
    private String servletName;
    private boolean forceInit;
    private final List<String> urlMappings = new ArrayList<String>();
    private final Map<String, String> initParams = new LinkedHashMap<String, String>();

    public Class<?> getServletClass() {
        return this.servletClass;
    }

    public void setServletClass(Class<?> servletClass) {
        this.servletClass = servletClass;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public ServletBuilder addUrlMapping(String mapping) {
        this.urlMappings.add(mapping);
        return this;
    }

    public ServletBuilder addUrlMappings(String ... mappings) {
        this.urlMappings.addAll(Arrays.asList(mappings));
        return this;
    }

    public ServletBuilder addUrlMappings(Collection<String> mappings) {
        this.urlMappings.addAll(mappings);
        return this;
    }

    public List<String> getUrlMappings() {
        return Collections.unmodifiableList(this.urlMappings);
    }

    public ServletBuilder addInitParam(String name, String value) {
        this.initParams.put(name, value);
        return this;
    }

    public Map<String, String> getInitParams() {
        return Collections.unmodifiableMap(this.initParams);
    }

    public boolean isForceInit() {
        return this.forceInit;
    }

    public void setForceInit(boolean forceInit) {
        this.forceInit = forceInit;
    }
}

