/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.inject.ConfigInjectionBean;
import io.smallrye.config.inject.ConfigProducer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class ConfigExtension
implements Extension {
    private Set<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();

    private void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        AnnotatedType configBean = bm.createAnnotatedType(ConfigProducer.class);
        bbd.addAnnotatedType(configBean, ConfigProducer.class.getName());
    }

    public void collectConfigProducer(@Observes ProcessInjectionPoint<?, ?> pip) {
        ConfigProperty configProperty = (ConfigProperty)pip.getInjectionPoint().getAnnotated().getAnnotation(ConfigProperty.class);
        if (configProperty != null) {
            this.injectionPoints.add(pip.getInjectionPoint());
        }
    }

    public void registerConfigProducer(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        Set<Class> types = this.injectionPoints.stream().filter(ip -> ip.getType() instanceof Class && ip.getType() != String.class && ip.getType() != Boolean.class && ip.getType() != Boolean.TYPE && ip.getType() != Integer.class && ip.getType() != Integer.TYPE && ip.getType() != Long.class && ip.getType() != Long.TYPE && ip.getType() != Float.class && ip.getType() != Float.TYPE && ip.getType() != Double.class && ip.getType() != Double.TYPE).map(ip -> (Class)ip.getType()).collect(Collectors.toSet());
        types.forEach(type -> abd.addBean(new ConfigInjectionBean(bm, (Class)type)));
    }

    public void validate(@Observes AfterDeploymentValidation add, BeanManager bm) {
        ArrayList<String> deploymentProblems = new ArrayList<String>();
        Config config = ConfigProvider.getConfig();
        for (InjectionPoint injectionPoint : this.injectionPoints) {
            String defaultValue;
            String key;
            Type type = injectionPoint.getType();
            ConfigProperty configProperty = (ConfigProperty)injectionPoint.getAnnotated().getAnnotation(ConfigProperty.class);
            if (type instanceof Class) {
                String defaultValue2;
                String key2 = ConfigExtension.getConfigKey(injectionPoint, configProperty);
                if (config.getOptionalValue(key2, (Class)type).isPresent() || (defaultValue2 = configProperty.defaultValue()) != null && !defaultValue2.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) continue;
                deploymentProblems.add("No Config Value exists for " + key2);
                continue;
            }
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)((ParameterizedType)type).getRawType();
            if (!Collection.class.isAssignableFrom(rawType) || config.getOptionalValue(key = ConfigExtension.getConfigKey(injectionPoint, configProperty), String.class).isPresent() || (defaultValue = configProperty.defaultValue()) != null && !defaultValue.equals("org.eclipse.microprofile.config.configproperty.unconfigureddvalue")) continue;
            deploymentProblems.add("No Config Value exists for " + key);
        }
        if (!deploymentProblems.isEmpty()) {
            add.addDeploymentProblem((Throwable)new DeploymentException("Error while validating Configuration:\n" + String.join((CharSequence)"\n", deploymentProblems)));
        }
    }

    private <T> Class<T> unwrapType(Type type) {
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    static String getConfigKey(InjectionPoint ip, ConfigProperty configProperty) {
        AnnotatedMember member;
        AnnotatedType declaringType;
        String key = configProperty.name();
        if (!key.trim().isEmpty()) {
            return key;
        }
        if (ip.getAnnotated() instanceof AnnotatedMember && (declaringType = (member = (AnnotatedMember)ip.getAnnotated()).getDeclaringType()) != null) {
            String[] parts = declaringType.getJavaClass().getCanonicalName().split("\\.");
            StringBuilder sb = new StringBuilder(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                sb.append(".").append(parts[i]);
            }
            sb.append(".").append(member.getJavaMember().getName());
            return sb.toString();
        }
        throw new IllegalStateException("Could not find default name for @ConfigProperty InjectionPoint " + ip);
    }
}

