/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import org.jberet.job.model.Job;
import org.jberet.job.model.JobParser;
import org.jberet.spi.JobXmlResolver;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet.deployment.BatchAttachments;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WildFlyJobXmlResolver
implements JobXmlResolver {
    private final Set<JobXmlResolver> jobXmlResolvers;
    private final Map<String, String> jobXmlNames = new LinkedHashMap<String, String>();
    private final Map<String, VirtualFile> jobXmlFiles;
    private final Map<String, Set<String>> jobNames;

    private WildFlyJobXmlResolver(Map<String, VirtualFile> jobXmlFiles) {
        this.jobXmlResolvers = new LinkedHashSet<JobXmlResolver>();
        this.jobNames = new LinkedHashMap<String, Set<String>>();
        this.jobXmlFiles = jobXmlFiles;
    }

    public static WildFlyJobXmlResolver forDeployment(DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        WildFlyJobXmlResolver resolver;
        if (deploymentUnit.hasAttachment(BatchAttachments.JOB_XML_RESOLVER)) {
            return (WildFlyJobXmlResolver)deploymentUnit.getAttachment(BatchAttachments.JOB_XML_RESOLVER);
        }
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ModuleClassLoader classLoader = module.getClassLoader();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            ArrayList<ResourceRoot> resources = new ArrayList<ResourceRoot>();
            for (ResourceRoot r : deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS)) {
                if (SubDeploymentMarker.isSubDeployment((ResourceRoot)r)) continue;
                resources.add(r);
            }
            resolver = WildFlyJobXmlResolver.create((ClassLoader)classLoader, resources);
            deploymentUnit.putAttachment(BatchAttachments.JOB_XML_RESOLVER, (Object)resolver);
        } else {
            resolver = deploymentUnit.hasAttachment(Attachments.RESOURCE_ROOTS) ? WildFlyJobXmlResolver.create((ClassLoader)classLoader, deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS)) : WildFlyJobXmlResolver.create((ClassLoader)classLoader, Collections.singletonList(deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)));
            deploymentUnit.putAttachment(BatchAttachments.JOB_XML_RESOLVER, (Object)resolver);
            List accessibleDeployments = deploymentUnit.getAttachmentList(Attachments.ACCESSIBLE_SUB_DEPLOYMENTS);
            for (DeploymentUnit subDeployment : accessibleDeployments) {
                WildFlyJobXmlResolver toCopy;
                if (deploymentUnit.equals(subDeployment)) continue;
                if (subDeployment.hasAttachment(BatchAttachments.JOB_XML_RESOLVER)) {
                    toCopy = (WildFlyJobXmlResolver)subDeployment.getAttachment(BatchAttachments.JOB_XML_RESOLVER);
                    WildFlyJobXmlResolver.merge(resolver, toCopy);
                    continue;
                }
                toCopy = WildFlyJobXmlResolver.forDeployment(subDeployment);
                subDeployment.putAttachment(BatchAttachments.JOB_XML_RESOLVER, (Object)toCopy);
                WildFlyJobXmlResolver.merge(resolver, toCopy);
            }
        }
        return resolver;
    }

    public InputStream resolveJobXml(String jobXml, ClassLoader classLoader) throws IOException {
        if (this.jobXmlFiles.isEmpty() && this.jobXmlResolvers.isEmpty()) {
            return null;
        }
        for (JobXmlResolver resolver : this.jobXmlResolvers) {
            InputStream in = resolver.resolveJobXml(jobXml, classLoader);
            if (in == null) continue;
            return in;
        }
        VirtualFile file = this.jobXmlFiles.get(jobXml);
        if (file == null) {
            return null;
        }
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(() -> {
                try {
                    return file.openStream();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return file.openStream();
    }

    public Collection<String> getJobXmlNames(ClassLoader classLoader) {
        return new ArrayList<String>(this.jobXmlNames.keySet());
    }

    public String resolveJobName(String jobXml, ClassLoader classLoader) {
        return this.jobXmlNames.get(jobXml);
    }

    boolean isValidJobName(String jobName) {
        return this.jobNames.containsKey(jobName);
    }

    Set<String> getJobXmlNames(String jobName) {
        if (this.jobNames.containsKey(jobName)) {
            return Collections.unmodifiableSet(this.jobNames.get(jobName));
        }
        return Collections.emptySet();
    }

    Set<String> getJobNames() {
        return new LinkedHashSet<String>(this.jobNames.keySet());
    }

    boolean isValidJobXmlName(String jobXmlName) {
        return this.jobXmlNames.containsKey(jobXmlName);
    }

    private static WildFlyJobXmlResolver create(ClassLoader classLoader, List<ResourceRoot> resources) throws DeploymentUnitProcessingException {
        LinkedHashMap<String, VirtualFile> foundJobXmlFiles = new LinkedHashMap<String, VirtualFile>();
        for (ResourceRoot r : resources) {
            VirtualFile root = r.getRoot();
            try {
                WildFlyJobXmlResolver.addJobXmlFiles(foundJobXmlFiles, root.getChild("META-INF/batch-jobs/"));
            }
            catch (IOException e) {
                throw BatchLogger.LOGGER.errorProcessingBatchJobsDir(e);
            }
        }
        WildFlyJobXmlResolver jobXmlResolver = new WildFlyJobXmlResolver(foundJobXmlFiles);
        jobXmlResolver.init(classLoader);
        return jobXmlResolver;
    }

    private static void addJobXmlFiles(Map<String, VirtualFile> foundJobXmlFiles, VirtualFile jobsDir) throws IOException {
        if (jobsDir != null && jobsDir.exists()) {
            HashMap<String, VirtualFile> xmlFiles = new HashMap<String, VirtualFile>();
            for (VirtualFile f : jobsDir.getChildren((VirtualFileFilter)JobXmlFilter.INSTANCE)) {
                if (xmlFiles.put(f.getName(), f) == null) continue;
                throw new IllegalStateException("Duplicate key");
            }
            foundJobXmlFiles.putAll(xmlFiles);
        }
    }

    private static void merge(WildFlyJobXmlResolver target, WildFlyJobXmlResolver toCopy) {
        for (Map.Entry<String, Set<String>> entry : toCopy.jobNames.entrySet()) {
            if (target.jobNames.containsKey(entry.getKey())) {
                target.jobNames.get(entry.getKey()).addAll((Collection<String>)entry.getValue());
                continue;
            }
            target.jobNames.put(entry.getKey(), entry.getValue());
        }
        toCopy.jobXmlNames.forEach(target.jobXmlNames::putIfAbsent);
        toCopy.jobXmlFiles.forEach(target.jobXmlFiles::putIfAbsent);
        target.jobXmlResolvers.addAll(toCopy.jobXmlResolvers);
    }

    private void init(ClassLoader classLoader) {
        for (JobXmlResolver jobXmlResolver : ServiceLoader.load(JobXmlResolver.class, classLoader)) {
            this.jobXmlResolvers.add(jobXmlResolver);
            for (String jobXml : jobXmlResolver.getJobXmlNames(classLoader)) {
                this.addJob(jobXml, jobXmlResolver.resolveJobName(jobXml, classLoader));
            }
        }
        for (Map.Entry entry : this.jobXmlFiles.entrySet()) {
            try {
                Job job = JobParser.parseJob((InputStream)((VirtualFile)entry.getValue()).openStream(), (ClassLoader)classLoader, (XMLResolver)new XMLResolver(){

                    @Override
                    public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                        try {
                            return WildFlyJobXmlResolver.this.jobXmlFiles.containsKey(systemID) ? ((VirtualFile)WildFlyJobXmlResolver.this.jobXmlFiles.get(systemID)).openStream() : null;
                        }
                        catch (IOException e) {
                            throw new XMLStreamException(e);
                        }
                    }
                });
                this.addJob((String)entry.getKey(), job.getId());
            }
            catch (IOException | XMLStreamException e) {
                BatchLogger.LOGGER.invalidJobXmlFile((String)entry.getKey());
            }
        }
    }

    private void addJob(String jobXmlName, String jobName) {
        this.jobXmlNames.put(jobXmlName, jobName);
        Set xmlDescriptors = this.jobNames.computeIfAbsent(jobName, s -> new LinkedHashSet());
        xmlDescriptors.add(jobXmlName);
    }

    private static class JobXmlFilter
    implements VirtualFileFilter {
        static final JobXmlFilter INSTANCE = new JobXmlFilter();

        private JobXmlFilter() {
        }

        public boolean accepts(VirtualFile file) {
            return file.isFile() && file.getName().endsWith(".xml");
        }
    }
}

