/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.netty.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.netty.transport.IoThreadPowered;

final class XnioEventLoop
extends AbstractEventExecutor
implements EventLoop,
IoThreadPowered {
    private final XnioIoThread executor;
    private final EventLoopGroup parent;

    XnioEventLoop(EventLoopGroup parent, XnioIoThread executor) {
        this.parent = parent;
        this.executor = executor;
    }

    XnioEventLoop(XnioIoThread executor) {
        this.parent = this;
        this.executor = executor;
    }

    @Override
    public XnioIoThread ioThread() {
        return this.executor;
    }

    public void shutdown() {
    }

    public EventLoopGroup parent() {
        return this.parent;
    }

    public boolean inEventLoop(Thread thread) {
        return thread == this.executor;
    }

    public ChannelFuture register(Channel channel) {
        return this.register(channel, channel.newPromise());
    }

    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (promise == null) {
            throw new NullPointerException("promise");
        }
        channel.unsafe().register((EventLoop)this, promise);
        return promise;
    }

    public ChannelFuture register(ChannelPromise promise) {
        return this.register(promise.channel(), promise);
    }

    public boolean isShuttingDown() {
        return this.executor.getWorker().isShutdown();
    }

    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        return this.newFailedFuture(new UnsupportedOperationException());
    }

    public Future<?> terminationFuture() {
        return this.newFailedFuture(new UnsupportedOperationException());
    }

    public boolean isShutdown() {
        return this.executor.getWorker().isShutdown();
    }

    public boolean isTerminated() {
        return this.executor.getWorker().isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.getWorker().awaitTermination(timeout, unit);
    }

    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.schedule(Executors.callable(command), delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        ScheduledFutureWrapper<V> wrapper = new ScheduledFutureWrapper<V>(callable, delay, unit);
        wrapper.key = this.executor.executeAfter(wrapper, delay, unit);
        return wrapper;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        FixedScheduledFuture wrapper = new FixedScheduledFuture(command, initialDelay, delay, unit);
        wrapper.key = this.executor.executeAfter((Runnable)wrapper, delay, unit);
        return wrapper;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        FixedRateScheduledFuture wrapper = new FixedRateScheduledFuture(command, initialDelay, period, unit);
        wrapper.key = this.executor.executeAfter((Runnable)wrapper, initialDelay, unit);
        return wrapper;
    }

    public XnioEventLoop next() {
        return this;
    }

    private class ScheduledFutureWrapper<V>
    extends DefaultPromise<V>
    implements ScheduledFuture<V>,
    Runnable {
        protected volatile XnioExecutor.Key key;
        protected final Callable<V> task;
        protected volatile long delay;
        protected volatile long start;

        ScheduledFutureWrapper(Callable<V> task, long delay, TimeUnit unit) {
            this.task = task;
            this.start = System.nanoTime();
            this.delay = unit.toNanos(delay);
        }

        public long getDelay(TimeUnit unit) {
            long remaining = this.start + this.delay - System.nanoTime();
            if (remaining < 1L || unit == TimeUnit.NANOSECONDS) {
                return remaining;
            }
            return unit.convert(remaining, TimeUnit.NANOSECONDS);
        }

        public int compareTo(Delayed o) {
            long d = this.getDelay(TimeUnit.NANOSECONDS) - o.getDelay(TimeUnit.NANOSECONDS);
            if (d < 0L) {
                return -1;
            }
            if (d > 0L) {
                return 1;
            }
            return 0;
        }

        @Override
        public void run() {
            try {
                this.trySuccess(this.task.call());
            }
            catch (Throwable t) {
                this.tryFailure(t);
            }
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.setUncancellable() && this.key.remove();
        }
    }

    private final class FixedScheduledFuture
    extends ScheduledFutureWrapper<Object> {
        private long furtherDelay;

        private FixedScheduledFuture(Runnable task, long initialDelay, long delay, TimeUnit unit) {
            super(Executors.callable(task), initialDelay, unit);
            this.furtherDelay = unit.toNanos(delay);
        }

        @Override
        public void run() {
            try {
                this.task.call();
                this.start = System.nanoTime();
                this.delay = this.furtherDelay;
                this.key = XnioEventLoop.this.executor.executeAfter((Runnable)this, this.furtherDelay, TimeUnit.NANOSECONDS);
            }
            catch (Throwable cause) {
                this.tryFailure(cause);
            }
        }
    }

    private final class FixedRateScheduledFuture
    extends ScheduledFutureWrapper<Object> {
        private final long period;
        private int count;
        private final long initialDelay;

        private FixedRateScheduledFuture(Runnable task, long delay, long period, TimeUnit unit) {
            super(Executors.callable(task), delay, unit);
            this.count = 1;
            this.initialDelay = delay;
            this.period = period;
        }

        @Override
        public void run() {
            try {
                this.task.call();
                this.start = System.nanoTime();
                this.delay = this.initialDelay + this.period * (long)(++this.count);
                this.key = XnioEventLoop.this.executor.executeAfter((Runnable)this, this.delay, TimeUnit.NANOSECONDS);
            }
            catch (Throwable cause) {
                this.tryFailure(cause);
            }
        }
    }
}

