/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4;

import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jipijapa.JipiLogger;

public class HibernatePatternFilter
implements VirtualFileFilter {
    private static final String SLASH = "/";
    private static final String PREFIX = "**/*";
    private final String pattern;
    private final boolean exact;

    public HibernatePatternFilter(String pattern) {
        if (pattern == null) {
            throw JipiLogger.JPA_LOGGER.nullVar("pattern");
        }
        this.exact = !pattern.contains(SLASH);
        this.pattern = !this.exact && pattern.startsWith(PREFIX) ? pattern.substring(4) : pattern;
    }

    protected boolean accepts(String name) {
        return this.exact ? name.equals(this.pattern) : name.endsWith(this.pattern);
    }

    public boolean accepts(VirtualFile file) {
        String name = this.exact ? file.getName() : file.getPathName();
        return this.accepts(name);
    }
}

