/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery.impl;

import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.wildfly.common.Assert;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceType;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryRequest;
import org.wildfly.discovery.spi.DiscoveryResult;

public final class AggregateDiscoveryProvider
implements DiscoveryProvider {
    private final DiscoveryProvider[] delegates;

    public AggregateDiscoveryProvider(DiscoveryProvider[] delegates) {
        Assert.checkNotNullParam((String)"delegates", (Object)delegates);
        this.delegates = delegates;
    }

    @Override
    public DiscoveryRequest discover(ServiceType serviceType, FilterSpec filterSpec, DiscoveryResult result) {
        AtomicInteger count = new AtomicInteger(this.delegates.length);
        DiscoveryRequest[] delegateRequests = new DiscoveryRequest[this.delegates.length];
        for (DiscoveryProvider delegate : this.delegates) {
            if (delegate != null) {
                delegateRequests[i] = delegate.discover(serviceType, filterSpec, new AggregatingDiscoveryResult(result, count));
                continue;
            }
            this.handleComplete(count, result);
        }
        return new AggregatingDiscoveryRequest(delegateRequests);
    }

    void handleComplete(AtomicInteger count, DiscoveryResult delegate) {
        if (count.decrementAndGet() == 0) {
            delegate.complete();
        }
    }

    final class AggregatingDiscoveryResult
    extends AtomicBoolean
    implements DiscoveryResult {
        private final DiscoveryResult delegate;
        private final AtomicInteger count;

        AggregatingDiscoveryResult(DiscoveryResult delegate, AtomicInteger count) {
            this.delegate = delegate;
            this.count = count;
        }

        @Override
        public void complete() {
            if (this.compareAndSet(false, true)) {
                AggregateDiscoveryProvider.this.handleComplete(this.count, this.delegate);
            }
        }

        @Override
        public void reportProblem(Throwable description) {
            if (!this.get()) {
                this.delegate.reportProblem(description);
            }
        }

        @Override
        public void addMatch(URI uri) {
            if (!this.get()) {
                this.delegate.addMatch(uri);
            }
        }

        @Override
        public void addMatch(ServiceURL serviceURL) {
            if (!this.get()) {
                this.delegate.addMatch(serviceURL);
            }
        }
    }

    static class AggregatingDiscoveryRequest
    implements DiscoveryRequest {
        private final DiscoveryRequest[] delegateRequests;

        AggregatingDiscoveryRequest(DiscoveryRequest[] delegateRequests) {
            this.delegateRequests = delegateRequests;
        }

        @Override
        public void cancel() {
            for (DiscoveryRequest request : this.delegateRequests) {
                if (request == null) continue;
                request.cancel();
            }
        }
    }
}

