/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.CDI11Deployment;
import org.jboss.weld.manager.BeanManagerImpl;

public class BeanManagerLookupService
implements Service {
    private final CDI11Deployment deployment;
    private final ConcurrentMap<BeanDeploymentArchive, BeanManagerImpl> bdaToBeanManagerMap;

    public BeanManagerLookupService(CDI11Deployment deployment, ConcurrentMap<BeanDeploymentArchive, BeanManagerImpl> bdaToBeanManagerMap) {
        this.deployment = deployment;
        this.bdaToBeanManagerMap = bdaToBeanManagerMap;
    }

    private BeanManagerImpl lookupBeanManager(Class<?> javaClass) {
        if (this.deployment == null) {
            return null;
        }
        BeanDeploymentArchive archive = this.deployment.getBeanDeploymentArchive(javaClass);
        if (archive == null) {
            return null;
        }
        return (BeanManagerImpl)this.bdaToBeanManagerMap.get(archive);
    }

    public static BeanManagerImpl lookupBeanManager(Class<?> javaClass, BeanManagerImpl fallback) {
        BeanManagerLookupService lookup = (BeanManagerLookupService)fallback.getServices().get(BeanManagerLookupService.class);
        if (lookup == null) {
            return fallback;
        }
        BeanManagerImpl result = lookup.lookupBeanManager(javaClass);
        if (result == null) {
            return fallback;
        }
        return result;
    }

    public void cleanup() {
    }
}

