/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.handler.ssl.SslHandler;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQInterruptedException;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.buffers.impl.ChannelBufferWrapper;
import org.hornetq.core.client.HornetQClientLogger;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.core.remoting.impl.netty.PartialPooledByteBufAllocator;
import org.hornetq.core.security.HornetQPrincipal;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.spi.core.remoting.ReadyListener;
import org.hornetq.utils.ConcurrentHashSet;

public class NettyConnection
implements Connection {
    private static final int BATCHING_BUFFER_SIZE = 8192;
    protected final Channel channel;
    private boolean closed;
    private final ConnectionLifeCycleListener listener;
    private final boolean batchingEnabled;
    private final boolean directDeliver;
    private volatile HornetQBuffer batchBuffer;
    private final Map<String, Object> configuration;
    private final Semaphore writeLock = new Semaphore(1);
    private final Set<ReadyListener> readyListeners = new ConcurrentHashSet();

    public NettyConnection(Map<String, Object> configuration, Channel channel, ConnectionLifeCycleListener listener, boolean batchingEnabled, boolean directDeliver) {
        this.configuration = configuration;
        this.channel = channel;
        this.listener = listener;
        this.batchingEnabled = batchingEnabled;
        this.directDeliver = directDeliver;
    }

    public Channel getNettyChannel() {
        return this.channel;
    }

    @Override
    public void forceClose() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Throwable e) {
                HornetQClientLogger.LOGGER.warn(e.getMessage(), e);
            }
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        final SslHandler sslHandler = (SslHandler)this.channel.pipeline().get("ssl");
        EventLoop eventLoop = this.channel.eventLoop();
        boolean inEventLoop = eventLoop.inEventLoop();
        if (!inEventLoop) {
            this.closeSSLAndChannel(sslHandler, this.channel);
        } else {
            eventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    NettyConnection.this.closeSSLAndChannel(sslHandler, NettyConnection.this.channel);
                }
            });
        }
        this.closed = true;
        this.listener.connectionDestroyed(this.getID());
    }

    @Override
    public HornetQBuffer createTransportBuffer(int size) {
        return new ChannelBufferWrapper(PartialPooledByteBufAllocator.INSTANCE.directBuffer(size), true);
    }

    @Override
    public Object getID() {
        return this.channel.hashCode();
    }

    @Override
    public void checkFlushBatchBuffer() {
        if (!this.batchingEnabled) {
            return;
        }
        if (this.writeLock.tryAcquire()) {
            try {
                if (this.batchBuffer != null && this.batchBuffer.readable()) {
                    this.channel.writeAndFlush((Object)this.batchBuffer.byteBuf());
                    this.batchBuffer = this.createTransportBuffer(8192);
                }
            }
            finally {
                this.writeLock.release();
            }
        }
    }

    @Override
    public void write(HornetQBuffer buffer) {
        this.write(buffer, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(HornetQBuffer buffer, boolean flush, boolean batched) {
        block14: {
            try {
                this.writeLock.acquire();
                try {
                    if (this.batchBuffer == null && this.batchingEnabled && batched && !flush) {
                        this.batchBuffer = HornetQBuffers.dynamicBuffer((int)8192);
                    }
                    if (this.batchBuffer != null) {
                        this.batchBuffer.writeBytes(buffer, 0, buffer.writerIndex());
                        if (this.batchBuffer.writerIndex() < 8192 && batched && !flush) {
                            return;
                        }
                        buffer = this.batchBuffer;
                        this.batchBuffer = !batched || flush ? null : HornetQBuffers.dynamicBuffer((int)8192);
                    }
                    final ByteBuf buf = buffer.byteBuf();
                    final ChannelPromise promise = flush ? this.channel.newPromise() : this.channel.voidPromise();
                    EventLoop eventLoop = this.channel.eventLoop();
                    boolean inEventLoop = eventLoop.inEventLoop();
                    if (!inEventLoop) {
                        this.channel.writeAndFlush((Object)buf, promise);
                    } else {
                        Runnable task = new Runnable(){

                            @Override
                            public void run() {
                                NettyConnection.this.channel.writeAndFlush((Object)buf, promise);
                            }
                        };
                        eventLoop.execute(task);
                    }
                    if (!flush || inEventLoop) break block14;
                    try {
                        boolean ok = promise.await(10000L);
                        if (!ok) {
                            HornetQClientLogger.LOGGER.timeoutFlushingPacket();
                        }
                    }
                    catch (InterruptedException e) {
                        throw new HornetQInterruptedException((Throwable)e);
                    }
                }
                finally {
                    this.writeLock.release();
                }
            }
            catch (InterruptedException e) {
                throw new HornetQInterruptedException((Throwable)e);
            }
        }
    }

    @Override
    public String getRemoteAddress() {
        SocketAddress address = this.channel.remoteAddress();
        if (address == null) {
            return null;
        }
        return address.toString();
    }

    public boolean isDirectDeliver() {
        return this.directDeliver;
    }

    @Override
    public void addReadyListener(ReadyListener listener) {
        this.readyListeners.add(listener);
    }

    @Override
    public void removeReadyListener(ReadyListener listener) {
        this.readyListeners.remove(listener);
    }

    @Override
    public HornetQPrincipal getDefaultHornetQPrincipal() {
        return null;
    }

    void fireReady(boolean ready) {
        for (ReadyListener listener : this.readyListeners) {
            listener.readyForWriting(ready);
        }
    }

    @Override
    public TransportConfiguration getConnectorConfig() {
        if (this.configuration != null) {
            return new TransportConfiguration(NettyConnectorFactory.class.getName(), this.configuration);
        }
        return null;
    }

    public String toString() {
        return super.toString() + "[local= " + this.channel.localAddress() + ", remote=" + this.channel.remoteAddress() + "]";
    }

    private void closeSSLAndChannel(SslHandler sslHandler, Channel channel) {
        ChannelFuture closeFuture;
        if (sslHandler != null) {
            try {
                ChannelFuture sslCloseFuture = sslHandler.close();
                if (!sslCloseFuture.awaitUninterruptibly(10000L)) {
                    HornetQClientLogger.LOGGER.timeoutClosingSSL();
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (!(closeFuture = channel.close()).awaitUninterruptibly(10000L)) {
            HornetQClientLogger.LOGGER.timeoutClosingNettyChannel();
        }
    }
}

