/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.MemoryPoolResourceDefinition;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.as.platform.mbean.logging.PlatformMBeanLogger;
import org.jboss.dmr.ModelNode;

class MemoryPoolMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    static final MemoryPoolMXBeanAttributeHandler INSTANCE = new MemoryPoolMXBeanAttributeHandler();
    private final ParametersValidator usageValidator = new ParametersValidator();

    private MemoryPoolMXBeanAttributeHandler() {
        this.usageValidator.registerValidator("value", (ParameterValidator)new LongRangeValidator(0L));
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String memPoolName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        String name = operation.require("name").asString();
        try {
            if (!(PlatformMBeanConstants.OBJECT_NAME.getName().equals(name) || MemoryPoolResourceDefinition.MEMORY_POOL_READ_ATTRIBUTES.contains(name) || MemoryPoolResourceDefinition.MEMORY_POOL_READ_WRITE_ATTRIBUTES.contains(name) || MemoryPoolResourceDefinition.MEMORY_POOL_METRICS.contains(name))) {
                throw MemoryPoolMXBeanAttributeHandler.unknownAttribute(operation);
            }
            MemoryPoolMXBean memoryPoolMXBean = MemoryPoolMXBeanAttributeHandler.getMemoryPoolMXBean(memPoolName);
            MemoryPoolMXBeanAttributeHandler.storeResult(name, context.getResult(), memoryPoolMXBean, memPoolName);
        }
        catch (UnsupportedOperationException e) {
            throw new OperationFailedException(e.toString());
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        block6: {
            String memPoolName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            MemoryPoolMXBean memoryPoolMXBean = MemoryPoolMXBeanAttributeHandler.getMemoryPoolMXBean(memPoolName);
            String name = operation.require("name").asString();
            try {
                if ("usage-threshold".equals(name)) {
                    context.getServiceRegistry(true);
                    this.usageValidator.validate(operation);
                    memoryPoolMXBean.setUsageThreshold(operation.require("value").asLong());
                    break block6;
                }
                if ("collection-usage-threshold".equals(name)) {
                    context.getServiceRegistry(true);
                    this.usageValidator.validate(operation);
                    memoryPoolMXBean.setCollectionUsageThreshold(operation.require("value").asLong());
                    break block6;
                }
                if (MemoryPoolResourceDefinition.MEMORY_POOL_READ_WRITE_ATTRIBUTES.contains(name)) {
                    throw PlatformMBeanLogger.ROOT_LOGGER.badWriteAttributeImpl(name);
                }
                throw MemoryPoolMXBeanAttributeHandler.unknownAttribute(operation);
            }
            catch (SecurityException e) {
                throw new OperationFailedException(e.toString());
            }
            catch (UnsupportedOperationException e) {
                throw new OperationFailedException(e.toString());
            }
        }
    }

    static void storeResult(String name, ModelNode store, MemoryPoolMXBean memoryPoolMXBean, String memPoolName) {
        if (PlatformMBeanConstants.OBJECT_NAME.getName().equals(name)) {
            String objName = PlatformMBeanUtil.getObjectNameStringWithNameKey("java.lang:type=MemoryPool", memPoolName);
            store.set(objName);
        } else if ("name".equals(name)) {
            store.set(PlatformMBeanUtil.escapeMBeanName(memoryPoolMXBean.getName()));
        } else if ("type".equals(name)) {
            store.set(memoryPoolMXBean.getType().name());
        } else if ("usage".equals(name)) {
            ModelNode usage = PlatformMBeanUtil.getDetypedMemoryUsage(memoryPoolMXBean.getUsage());
            store.set(usage);
        } else if ("peak-usage".equals(name)) {
            ModelNode usage = PlatformMBeanUtil.getDetypedMemoryUsage(memoryPoolMXBean.getPeakUsage());
            store.set(usage);
        } else if (PlatformMBeanConstants.VALID.getName().equals(name)) {
            store.set(memoryPoolMXBean.isValid());
        } else if ("memory-manager-names".equals(name)) {
            store.setEmptyList();
            for (String mgr : memoryPoolMXBean.getMemoryManagerNames()) {
                store.add(PlatformMBeanUtil.escapeMBeanName(mgr));
            }
        } else if ("usage-threshold".equals(name)) {
            store.set(memoryPoolMXBean.getUsageThreshold());
        } else if ("usage-threshold-exceeded".equals(name)) {
            store.set(memoryPoolMXBean.isUsageThresholdExceeded());
        } else if ("usage-threshold-count".equals(name)) {
            store.set(memoryPoolMXBean.getUsageThresholdCount());
        } else if ("usage-threshold-supported".equals(name)) {
            store.set(memoryPoolMXBean.isUsageThresholdSupported());
        } else if ("collection-usage-threshold".equals(name)) {
            store.set(memoryPoolMXBean.getCollectionUsageThreshold());
        } else if ("collection-usage-threshold-exceeded".equals(name)) {
            store.set(memoryPoolMXBean.isCollectionUsageThresholdExceeded());
        } else if ("collection-usage-threshold-count".equals(name)) {
            store.set(memoryPoolMXBean.getCollectionUsageThresholdCount());
        } else if ("collection-usage-threshold-supported".equals(name)) {
            store.set(memoryPoolMXBean.isCollectionUsageThresholdSupported());
        } else if ("collection-usage".equals(name)) {
            ModelNode usage = PlatformMBeanUtil.getDetypedMemoryUsage(memoryPoolMXBean.getCollectionUsage());
            store.set(usage);
        } else if (MemoryPoolResourceDefinition.MEMORY_POOL_READ_ATTRIBUTES.contains(name) || MemoryPoolResourceDefinition.MEMORY_POOL_READ_WRITE_ATTRIBUTES.contains(name) || MemoryPoolResourceDefinition.MEMORY_POOL_METRICS.contains(name)) {
            throw PlatformMBeanLogger.ROOT_LOGGER.badReadAttributeImpl(name);
        }
    }

    static MemoryPoolMXBean getMemoryPoolMXBean(String memPoolName) throws OperationFailedException {
        MemoryPoolMXBean memoryPoolMXBean = null;
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memPoolName.equals(PlatformMBeanUtil.escapeMBeanName(mbean.getName()))) continue;
            memoryPoolMXBean = mbean;
        }
        if (memoryPoolMXBean == null) {
            throw PlatformMBeanLogger.ROOT_LOGGER.unknownMemoryPool(memPoolName);
        }
        return memoryPoolMXBean;
    }
}

