/*
 * Decompiled with CFR 0.152.
 */
package org.apache.html.dom;

import org.apache.html.dom.HTMLCollectionImpl;
import org.apache.html.dom.HTMLDocumentImpl;
import org.apache.html.dom.HTMLElementImpl;
import org.apache.html.dom.HTMLTableCellElementImpl;
import org.apache.html.dom.HTMLTableElementImpl;
import org.apache.html.dom.HTMLTableSectionElementImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;
import org.w3c.dom.html.HTMLTableSectionElement;

public class HTMLTableRowElementImpl
extends HTMLElementImpl
implements HTMLTableRowElement {
    private static final long serialVersionUID = 5409562635656244263L;
    HTMLCollection _cells;

    public int getRowIndex() {
        Node parent = this.getParentNode();
        if (parent instanceof HTMLTableSectionElement) {
            parent = parent.getParentNode();
        }
        if (parent instanceof HTMLTableElement) {
            return this.getRowIndex(parent);
        }
        return -1;
    }

    public void setRowIndex(int rowIndex) {
        Node parent = this.getParentNode();
        if (parent instanceof HTMLTableSectionElement) {
            parent = parent.getParentNode();
        }
        if (parent instanceof HTMLTableElement) {
            ((HTMLTableElementImpl)parent).insertRowX(rowIndex, this);
        }
    }

    public int getSectionRowIndex() {
        Node parent = this.getParentNode();
        if (parent instanceof HTMLTableSectionElement) {
            return this.getRowIndex(parent);
        }
        return -1;
    }

    public void setSectionRowIndex(int sectionRowIndex) {
        Node parent = this.getParentNode();
        if (parent instanceof HTMLTableSectionElement) {
            ((HTMLTableSectionElementImpl)parent).insertRowX(sectionRowIndex, this);
        }
    }

    int getRowIndex(Node parent) {
        NodeList rows = ((HTMLElement)parent).getElementsByTagName("TR");
        for (int i = 0; i < rows.getLength(); ++i) {
            if (rows.item(i) != this) continue;
            return i;
        }
        return -1;
    }

    public HTMLCollection getCells() {
        if (this._cells == null) {
            this._cells = new HTMLCollectionImpl(this, -3);
        }
        return this._cells;
    }

    public void setCells(HTMLCollection cells) {
        Node child;
        for (child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.removeChild(child);
        }
        int i = 0;
        child = cells.item(i);
        while (child != null) {
            this.appendChild(child);
            child = cells.item(++i);
        }
    }

    public HTMLElement insertCell(int index) {
        HTMLTableCellElementImpl newCell = new HTMLTableCellElementImpl((HTMLDocumentImpl)this.getOwnerDocument(), "TD");
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof HTMLTableCellElement)) continue;
            if (index == 0) {
                this.insertBefore(newCell, child);
                return newCell;
            }
            --index;
        }
        this.appendChild(newCell);
        return newCell;
    }

    public void deleteCell(int index) {
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof HTMLTableCellElement)) continue;
            if (index == 0) {
                this.removeChild(child);
                return;
            }
            --index;
        }
    }

    public String getAlign() {
        return this.capitalize(this.getAttribute("align"));
    }

    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    public void setBgColor(String bgColor) {
        this.setAttribute("bgcolor", bgColor);
    }

    public String getCh() {
        String ch = this.getAttribute("char");
        if (ch != null && ch.length() > 1) {
            ch = ch.substring(0, 1);
        }
        return ch;
    }

    public void setCh(String ch) {
        if (ch != null && ch.length() > 1) {
            ch = ch.substring(0, 1);
        }
        this.setAttribute("char", ch);
    }

    public String getChOff() {
        return this.getAttribute("charoff");
    }

    public void setChOff(String chOff) {
        this.setAttribute("charoff", chOff);
    }

    public String getVAlign() {
        return this.capitalize(this.getAttribute("valign"));
    }

    public void setVAlign(String vAlign) {
        this.setAttribute("valign", vAlign);
    }

    public Node cloneNode(boolean deep) {
        HTMLTableRowElementImpl clonedNode = (HTMLTableRowElementImpl)super.cloneNode(deep);
        clonedNode._cells = null;
        return clonedNode;
    }

    public HTMLTableRowElementImpl(HTMLDocumentImpl owner, String name) {
        super(owner, name);
    }
}

