/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.batch.impl;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.cli.Attachments;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.dmr.ModelNode;

public class DefaultBatch
implements Batch {
    private final List<BatchedCommand> commands = new ArrayList<BatchedCommand>();
    private final Attachments attachments = new Attachments();

    @Override
    public List<BatchedCommand> getCommands() {
        return this.commands;
    }

    @Override
    public void add(BatchedCommand cmd) {
        if (cmd == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        this.commands.add(cmd);
    }

    @Override
    public void clear() {
        this.commands.clear();
    }

    @Override
    public void remove(int lineNumber) {
        this.ensureRange(lineNumber);
        this.commands.remove(lineNumber);
    }

    @Override
    public void set(int index, BatchedCommand cmd) {
        this.ensureRange(index);
        this.commands.set(index, cmd);
    }

    protected void ensureRange(int lineNumber) {
        if (lineNumber < 0 || lineNumber > this.commands.size() - 1) {
            throw new IndexOutOfBoundsException(lineNumber + " isn't in range [0.." + (this.commands.size() - 1) + "]");
        }
    }

    @Override
    public int size() {
        return this.commands.size();
    }

    @Override
    public void move(int currentIndex, int newIndex) {
        this.ensureRange(currentIndex);
        this.ensureRange(newIndex);
        if (currentIndex == newIndex) {
            return;
        }
        BatchedCommand cmd = this.commands.get(currentIndex);
        int step = newIndex > currentIndex ? 1 : -1;
        for (int i = currentIndex; i != newIndex; i += step) {
            this.commands.set(i, this.commands.get(i + step));
        }
        this.commands.set(newIndex, cmd);
    }

    @Override
    public ModelNode toRequest() {
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        for (BatchedCommand cmd : this.commands) {
            CommandContext ctx = cmd.getCommandContext();
            ModelNode request = cmd.getRequest();
            if (ctx.getConfig().isValidateOperationRequests()) {
                try {
                    ctx.set(CommandContext.Scope.REQUEST, "DESCRIPTION_RESPONSE", cmd.getDescriptionResponse());
                    ModelNode opDescOutcome = Util.validateRequest(ctx, request);
                    if (opDescOutcome != null) {
                        Util.replaceFilePathsWithBytes(request, opDescOutcome);
                    }
                }
                catch (CommandFormatException ex) {
                    throw new RuntimeException(ex);
                }
                finally {
                    ctx.remove(CommandContext.Scope.REQUEST, "DESCRIPTION_RESPONSE");
                }
            }
            steps.add(request);
        }
        return composite;
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }
}

