/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringAllowedValuesValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.extension.elytron.capabilities.CredentialSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.sasl.SaslMechanismSelector;

class AuthenticationClientDefinitions {
    static final SimpleAttributeDefinition CONFIGURATION_EXTENDS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("extends", ModelType.STRING, true).setRestartAllServices()).setCapabilityReference("org.wildfly.security.authentication-configuration", Capabilities.AUTHENTICATION_CONFIGURATION_RUNTIME_CAPABILITY)).build();
    static final SimpleAttributeDefinition ANONYMOUS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("anonymous", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setAlternatives(new String[]{"authentication-name", "kerberos-security-factory"})).setRestartAllServices()).build();
    static final SimpleAttributeDefinition AUTHENTICATION_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-name", ModelType.STRING, true).setAllowExpression(true)).setAlternatives(new String[]{"anonymous", "kerberos-security-factory"})).setRestartAllServices()).build();
    static final SimpleAttributeDefinition AUTHORIZATION_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authorization-name", ModelType.STRING, true).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition HOST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("host", ModelType.STRING, true).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("protocol", ModelType.STRING, true).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("port", ModelType.INT, true).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm", ModelType.STRING, true).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-domain", ModelType.STRING, true).setAllowExpression(false)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.security-domain", Capabilities.AUTHENTICATION_CONFIGURATION_RUNTIME_CAPABILITY)).build();
    static final SimpleAttributeDefinition FORWARDING_MODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("forwarding-mode", ModelType.STRING, true).setAllowExpression(true)).setRestartAllServices()).setAllowedValues(new String[]{"authentication", "authorization"})).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"authentication", "authorization"}))).setDefaultValue(new ModelNode("authentication"))).build();
    static final SimpleAttributeDefinition SASL_MECHANISM_SELECTOR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sasl-mechanism-selector", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final PropertiesAttributeDefinition MECHANISM_PROPERTIES = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("properties", true).setName("mechanism-properties")).setXmlName("mechanism-properties").setRestartAllServices()).build();
    static final ObjectTypeAttributeDefinition CREDENTIAL_REFERENCE = ((ObjectTypeAttributeDefinition.Builder)CredentialReference.getAttributeBuilder((boolean)true, (boolean)true).setRestartAllServices()).build();
    static final SimpleAttributeDefinition KERBEROS_SECURITY_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("kerberos-security-factory", ModelType.STRING, true).setRestartAllServices()).setAlternatives(new String[]{"anonymous", "authentication-name"})).setCapabilityReference("org.wildfly.security.security-factory.credential", Capabilities.AUTHENTICATION_CONFIGURATION_RUNTIME_CAPABILITY)).build();
    static final AttributeDefinition[] AUTHENTICATION_CONFIGURATION_SIMPLE_ATTRIBUTES = new AttributeDefinition[]{CONFIGURATION_EXTENDS, ANONYMOUS, AUTHENTICATION_NAME, AUTHORIZATION_NAME, HOST, PROTOCOL, PORT, REALM, SECURITY_DOMAIN, FORWARDING_MODE, SASL_MECHANISM_SELECTOR, KERBEROS_SECURITY_FACTORY};
    static final AttributeDefinition[] AUTHENTICATION_CONFIGURATION_ALL_ATTRIBUTES = new AttributeDefinition[]{CONFIGURATION_EXTENDS, ANONYMOUS, AUTHENTICATION_NAME, AUTHORIZATION_NAME, HOST, PROTOCOL, PORT, REALM, SECURITY_DOMAIN, FORWARDING_MODE, KERBEROS_SECURITY_FACTORY, SASL_MECHANISM_SELECTOR, MECHANISM_PROPERTIES, CREDENTIAL_REFERENCE};
    static final SimpleAttributeDefinition MATCH_USER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-user", ModelType.STRING, true).setAllowExpression(true)).setAlternatives(new String[]{"match-no-user"})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_NO_USER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-no-user", ModelType.BOOLEAN, true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setAlternatives(new String[]{"match-user"})).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_URN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-urn", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_LOCAL_SECURITY_DOMAIN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-local-security-domain", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-protocol", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_ABSTRACT_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-abstract-type", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_ABSTRACT_TYPE_AUTHORITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-abstract-type-authority", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_HOST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-host", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-path", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MATCH_PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("match-port", ModelType.INT, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CONTEXT_EXTENDS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("extends", ModelType.STRING, true).setRestartAllServices()).setCapabilityReference("org.wildfly.security.authentication-context", Capabilities.AUTHENTICATION_CONTEXT_RUNTIME_CAPABILITY)).build();
    static final SimpleAttributeDefinition AUTHENTICATION_CONFIGURATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-configuration", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.authentication-configuration", Capabilities.AUTHENTICATION_CONTEXT_RUNTIME_CAPABILITY)).build();
    static final SimpleAttributeDefinition SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-context", ModelType.STRING, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setCapabilityReference("org.wildfly.security.ssl-context", Capabilities.AUTHENTICATION_CONTEXT_RUNTIME_CAPABILITY)).build();
    static final ObjectTypeAttributeDefinition MATCH_RULE = new ObjectTypeAttributeDefinition.Builder("match-rule", new AttributeDefinition[]{MATCH_ABSTRACT_TYPE, MATCH_ABSTRACT_TYPE_AUTHORITY, MATCH_HOST, MATCH_LOCAL_SECURITY_DOMAIN, MATCH_NO_USER, MATCH_PATH, MATCH_PORT, MATCH_PROTOCOL, MATCH_URN, MATCH_USER, AUTHENTICATION_CONFIGURATION, SSL_CONTEXT}).build();
    static final ObjectListAttributeDefinition MATCH_RULES = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("match-rules", MATCH_RULE).setRequired(false)).setRestartAllServices()).build();

    AuthenticationClientDefinitions() {
    }

    static ResourceDefinition getAuthenticationClientDefinition() {
        TrivialAddHandler<AuthenticationConfiguration> add = new TrivialAddHandler<AuthenticationConfiguration>(AuthenticationConfiguration.class, AUTHENTICATION_CONFIGURATION_ALL_ATTRIBUTES, Capabilities.AUTHENTICATION_CONFIGURATION_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<AuthenticationConfiguration> getValueSupplier(ServiceBuilder<AuthenticationConfiguration> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                ModelNode credentialReference;
                ModelNode properties;
                String kerberosSecurityFactory;
                String saslMechanismSelector;
                Supplier<AuthenticationConfiguration> parentSupplier;
                String parent = CONFIGURATION_EXTENDS.resolveModelAttribute(context, model).asStringOrNull();
                if (parent != null) {
                    InjectedValue parentInjector = new InjectedValue();
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.authentication-configuration", (String)parent), AuthenticationConfiguration.class), AuthenticationConfiguration.class, (Injector)parentInjector);
                    parentSupplier = () -> ((InjectedValue)parentInjector).getValue();
                } else {
                    parentSupplier = () -> AuthenticationConfiguration.EMPTY;
                }
                Function<AuthenticationConfiguration, AuthenticationConfiguration> configuration = ignored -> (AuthenticationConfiguration)parentSupplier.get();
                boolean anonymous = ANONYMOUS.resolveModelAttribute(context, model).asBoolean();
                configuration = anonymous ? configuration.andThen(c -> c.useAnonymous()) : configuration;
                String authenticationName = AUTHENTICATION_NAME.resolveModelAttribute(context, model).asStringOrNull();
                configuration = authenticationName != null ? configuration.andThen(c -> c.useName(authenticationName)) : configuration;
                String authorizationName = AUTHORIZATION_NAME.resolveModelAttribute(context, model).asStringOrNull();
                configuration = authorizationName != null ? configuration.andThen(c -> c.useAuthorizationName(authorizationName)) : configuration;
                String host = HOST.resolveModelAttribute(context, model).asStringOrNull();
                configuration = host != null ? configuration.andThen(c -> c.useHost(host)) : configuration;
                String protocol = PROTOCOL.resolveModelAttribute(context, model).asStringOrNull();
                configuration = protocol != null ? configuration.andThen(c -> c.useProtocol(protocol)) : configuration;
                int port = PORT.resolveModelAttribute(context, model).asInt(-1);
                configuration = port > 0 ? configuration.andThen(c -> c.usePort(port)) : configuration;
                String realm = REALM.resolveModelAttribute(context, model).asStringOrNull();
                configuration = realm != null ? configuration.andThen(c -> c.useRealm(realm)) : configuration;
                String securityDomain = SECURITY_DOMAIN.resolveModelAttribute(context, model).asStringOrNull();
                String forwardAuth = FORWARDING_MODE.resolveModelAttribute(context, model).asStringOrNull();
                if (securityDomain != null) {
                    InjectedValue<SecurityDomain> securityDomainInjector = this.getSecurityDomain(serviceBuilder, context, securityDomain);
                    configuration = "authorization".equals(forwardAuth) ? configuration.andThen(c -> c.useForwardedAuthorizationIdentity((SecurityDomain)securityDomainInjector.getValue())) : configuration.andThen(c -> c.useForwardedIdentity((SecurityDomain)securityDomainInjector.getValue()));
                }
                if ((saslMechanismSelector = SASL_MECHANISM_SELECTOR.resolveModelAttribute(context, model).asStringOrNull()) != null) {
                    SaslMechanismSelector selector = SaslMechanismSelector.fromString((String)saslMechanismSelector);
                    Function<AuthenticationConfiguration, AuthenticationConfiguration> function = configuration = selector != null ? configuration.andThen(c -> c.setSaslMechanismSelector(selector)) : configuration;
                }
                if ((kerberosSecurityFactory = KERBEROS_SECURITY_FACTORY.resolveModelAttribute(context, model).asStringOrNull()) != null) {
                    InjectedValue kerberosFactoryInjector = new InjectedValue();
                    serviceBuilder.addDependency(context.getCapabilityServiceName("org.wildfly.security.security-factory.credential", kerberosSecurityFactory, CredentialSecurityFactory.class), CredentialSecurityFactory.class, (Injector)kerberosFactoryInjector);
                    configuration = configuration.andThen(c -> c.useKerberosSecurityFactory((SecurityFactory)kerberosFactoryInjector.getValue()));
                }
                if ((properties = MECHANISM_PROPERTIES.resolveModelAttribute(context, model)).isDefined()) {
                    HashMap<String, String> propertiesMap = new HashMap<String, String>();
                    for (String s : properties.keys()) {
                        propertiesMap.put(s, properties.require(s).asString());
                    }
                    configuration = configuration.andThen(c -> c.useMechanismProperties(propertiesMap, parent == null));
                }
                if ((credentialReference = CREDENTIAL_REFERENCE.resolveModelAttribute(context, model)).isDefined()) {
                    InjectedValue credentialSourceSupplierInjector = new InjectedValue();
                    credentialSourceSupplierInjector.inject((Object)CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)CREDENTIAL_REFERENCE, (ModelNode)model, serviceBuilder));
                    configuration = configuration.andThen(c -> {
                        ExceptionSupplier sourceSupplier = (ExceptionSupplier)credentialSourceSupplierInjector.getValue();
                        try {
                            CredentialSource cs = (CredentialSource)sourceSupplier.get();
                            if (cs != null) {
                                String alias;
                                PasswordCredential passCredential = (PasswordCredential)cs.getCredential(PasswordCredential.class);
                                String string = alias = credentialReference.hasDefined("alias") ? credentialReference.get("alias").asString() : null;
                                if (passCredential == null) {
                                    if (alias != null && alias.length() > 0) {
                                        throw ElytronSubsystemMessages.ROOT_LOGGER.credentialDoesNotExist(alias, PasswordCredential.class.getName());
                                    }
                                    throw ElytronSubsystemMessages.ROOT_LOGGER.credentialCannotBeResolved();
                                }
                                return c.usePassword(passCredential.getPassword());
                            }
                            throw ElytronSubsystemMessages.ROOT_LOGGER.credentialCannotBeResolved();
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(e);
                        }
                    });
                }
                Function<AuthenticationConfiguration, AuthenticationConfiguration> finalConfiguration = configuration;
                return () -> {
                    try {
                        return (AuthenticationConfiguration)finalConfiguration.apply(null);
                    }
                    catch (IllegalStateException e) {
                        if (e.getCause() != null) {
                            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService((Exception)e.getCause());
                        }
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
                    }
                };
            }

            private InjectedValue<SecurityDomain> getSecurityDomain(ServiceBuilder<AuthenticationConfiguration> serviceBuilder, OperationContext context, String securityDomain) {
                InjectedValue securityDomainInjector = new InjectedValue();
                serviceBuilder.addDependency(context.getCapabilityServiceName("org.wildfly.security.security-domain", securityDomain, SecurityDomain.class), SecurityDomain.class, (Injector)securityDomainInjector);
                return securityDomainInjector;
            }
        };
        return new TrivialResourceDefinition("authentication-configuration", add, AUTHENTICATION_CONFIGURATION_ALL_ATTRIBUTES, Capabilities.AUTHENTICATION_CONFIGURATION_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getAuthenticationContextDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{CONTEXT_EXTENDS, MATCH_RULES};
        TrivialAddHandler<AuthenticationContext> add = new TrivialAddHandler<AuthenticationContext>(AuthenticationContext.class, attributes, Capabilities.AUTHENTICATION_CONTEXT_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<AuthenticationContext> getValueSupplier(ServiceBuilder<AuthenticationContext> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                Supplier<AuthenticationContext> parentSupplier;
                String parent = CONTEXT_EXTENDS.resolveModelAttribute(context, model).asStringOrNull();
                if (parent != null) {
                    InjectedValue parentInjector = new InjectedValue();
                    serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.authentication-context", (String)parent), AuthenticationContext.class), AuthenticationContext.class, (Injector)parentInjector);
                    parentSupplier = () -> ((InjectedValue)parentInjector).getValue();
                } else {
                    parentSupplier = AuthenticationContext::empty;
                }
                Function authContext = Function.identity();
                if (model.hasDefined("match-rules")) {
                    List nodes = model.require("match-rules").asList();
                    for (ModelNode current : nodes) {
                        String authenticationConfiguration = AUTHENTICATION_CONFIGURATION.resolveModelAttribute(context, current).asStringOrNull();
                        String sslContext = SSL_CONTEXT.resolveModelAttribute(context, current).asStringOrNull();
                        if (authenticationConfiguration == null && sslContext == null) continue;
                        Function<MatchRule, MatchRule> matchRule = ignored -> MatchRule.ALL;
                        String abstractType = MATCH_ABSTRACT_TYPE.resolveModelAttribute(context, current).asStringOrNull();
                        String abstractTypeAuthority = MATCH_ABSTRACT_TYPE_AUTHORITY.resolveModelAttribute(context, current).asStringOrNull();
                        matchRule = abstractType != null || abstractTypeAuthority != null ? matchRule.andThen(m -> m.matchAbstractType(abstractType, abstractTypeAuthority)) : matchRule;
                        ModelNode host = MATCH_HOST.resolveModelAttribute(context, current);
                        matchRule = host.isDefined() ? matchRule.andThen(m -> m.matchHost(host.asString())) : matchRule;
                        ModelNode localSecurityDomain = MATCH_LOCAL_SECURITY_DOMAIN.resolveModelAttribute(context, current);
                        matchRule = localSecurityDomain.isDefined() ? matchRule.andThen(m -> m.matchLocalSecurityDomain(localSecurityDomain.asString())) : matchRule;
                        ModelNode matchNoUser = MATCH_NO_USER.resolveModelAttribute(context, current);
                        matchRule = matchNoUser.asBoolean() ? matchRule.andThen(m -> m.matchNoUser()) : matchRule;
                        ModelNode path = MATCH_PATH.resolveModelAttribute(context, current);
                        matchRule = path.isDefined() ? matchRule.andThen(m -> m.matchPath(path.asString())) : matchRule;
                        ModelNode port = MATCH_PORT.resolveModelAttribute(context, current);
                        matchRule = port.isDefined() ? matchRule.andThen(m -> m.matchPort(port.asInt())) : matchRule;
                        ModelNode protocol = MATCH_PROTOCOL.resolveModelAttribute(context, current);
                        matchRule = protocol.isDefined() ? matchRule.andThen(m -> m.matchProtocol(protocol.asString())) : matchRule;
                        ModelNode urn = MATCH_URN.resolveModelAttribute(context, current);
                        matchRule = urn.isDefined() ? matchRule.andThen(m -> m.matchUrnName(urn.asString())) : matchRule;
                        ModelNode user = MATCH_USER.resolveModelAttribute(context, current);
                        Function<MatchRule, MatchRule> finalMatchRule = matchRule = user.isDefined() ? matchRule.andThen(m -> m.matchUser(user.asString())) : matchRule;
                        OneTimeSupplier<MatchRule> matchRuleSuppler = new OneTimeSupplier<MatchRule>(() -> (MatchRule)finalMatchRule.apply(null));
                        if (authenticationConfiguration != null) {
                            InjectedValue authenticationConfigurationInjector = new InjectedValue();
                            serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.authentication-configuration", (String)authenticationConfiguration), AuthenticationConfiguration.class), AuthenticationConfiguration.class, (Injector)authenticationConfigurationInjector);
                            authContext = authContext.andThen(a -> a.with((MatchRule)matchRuleSuppler.get(), (AuthenticationConfiguration)authenticationConfigurationInjector.getValue()));
                        }
                        if (sslContext == null) continue;
                        InjectedValue sslContextInjector = new InjectedValue();
                        serviceBuilder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.ssl-context", (String)sslContext), SSLContext.class), SSLContext.class, (Injector)sslContextInjector);
                        authContext = authContext.andThen(a -> a.withSsl((MatchRule)matchRuleSuppler.get(), () -> ((InjectedValue)sslContextInjector).getValue()));
                    }
                }
                Function finalContext = authContext;
                return () -> (AuthenticationContext)finalContext.apply(parentSupplier.get());
            }
        };
        return new TrivialResourceDefinition("authentication-context", add, attributes, Capabilities.AUTHENTICATION_CONTEXT_RUNTIME_CAPABILITY);
    }

    static final class OneTimeSupplier<T>
    implements Supplier<T> {
        private final Supplier<T> supplier;
        private T value;

        OneTimeSupplier(Supplier<T> supplier) {
            Assert.checkNotNullParam((String)"supplier", supplier);
            this.supplier = supplier;
        }

        @Override
        public T get() {
            if (this.value == null) {
                this.value = this.supplier.get();
            }
            return this.value;
        }
    }
}

