/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.SecurityActions;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

class CustomComponentDefinition<C, T>
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ClassLoadingAttributeDefinitions.MODULE).setRequired(true)).setRestartAllServices()).build();
    static final PropertiesAttributeDefinition CONFIGURATION = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("configuration", true).setAllowExpression(true)).setRestartAllServices()).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{MODULE, ClassLoadingAttributeDefinitions.CLASS_NAME, CONFIGURATION};

    CustomComponentDefinition(Class<C> serviceType, Function<C, T> wrapper, String pathKey, RuntimeCapability ... runtimeCapabilities) {
        super(CustomComponentDefinition.addAddRemoveHandlers(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)pathKey), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver(pathKey)).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(runtimeCapabilities), serviceType, wrapper, runtimeCapabilities));
    }

    private static <C, T> SimpleResourceDefinition.Parameters addAddRemoveHandlers(SimpleResourceDefinition.Parameters parameters, Class<C> serviceType, Function<C, T> wrapper, RuntimeCapability<?> ... runtimeCapabilities) {
        ComponentAddHandler add = new ComponentAddHandler((Class)serviceType, (Function)wrapper, (RuntimeCapability[])runtimeCapabilities);
        TrivialCapabilityServiceRemoveHandler remove = new TrivialCapabilityServiceRemoveHandler(add, runtimeCapabilities);
        parameters.setAddHandler(add);
        parameters.setRemoveHandler((OperationStepHandler)remove);
        return parameters;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ElytronReloadRequiredWriteAttributeHandler writeHandler = new ElytronReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition current : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(current, null, (OperationStepHandler)writeHandler);
        }
    }

    private static class ComponentAddHandler<C, T>
    extends BaseAddHandler {
        private final RuntimeCapability<?>[] runtimeCapabilities;
        private final Class<C> serviceType;
        private final Function<C, T> wrapper;

        private ComponentAddHandler(Class<C> serviceType, Function<C, T> wrapper, RuntimeCapability<?> ... runtimeCapabilities) {
            super(new HashSet<RuntimeCapability>(Arrays.asList(runtimeCapabilities)), ATTRIBUTES);
            this.runtimeCapabilities = runtimeCapabilities;
            this.serviceType = serviceType;
            this.wrapper = wrapper;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            String address = context.getCurrentAddressValue();
            RuntimeCapability<?> primaryCapability = this.runtimeCapabilities[0];
            ServiceName primaryServiceName = this.toServiceName(primaryCapability, address);
            String module = MODULE.resolveModelAttribute(context, model).asStringOrNull();
            String className = ClassLoadingAttributeDefinitions.CLASS_NAME.resolveModelAttribute(context, model).asString();
            Map configurationMap = CONFIGURATION.unwrap((ExpressionResolver)context, model);
            ServiceBuilder serviceBuilder = serviceTarget.addService(primaryServiceName);
            for (int i = 1; i < this.runtimeCapabilities.length; ++i) {
                serviceBuilder.addAliases(new ServiceName[]{this.toServiceName(this.runtimeCapabilities[i], address)});
            }
            ElytronDefinition.commonRequirements(serviceBuilder).setInstance(new TrivialService<Object>(() -> this.createValue(module, className, configurationMap))).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        private ServiceName toServiceName(RuntimeCapability<?> runtimeCapability, String addressValue) {
            return runtimeCapability.fromBaseCapability(addressValue).getCapabilityServiceName();
        }

        private T createValue(String module, String className, Map<String, String> configuration) throws StartException {
            try {
                ClassLoader classLoader = SecurityActions.doPrivileged(() -> ClassLoadingAttributeDefinitions.resolveClassLoader(module));
                Class<C> typeClazz = classLoader.loadClass(className).asSubclass(this.serviceType);
                C component = typeClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (configuration != null && !configuration.isEmpty()) {
                    try {
                        Method method = component.getClass().getMethod("initialize", Map.class);
                        method.invoke(component, configuration);
                    }
                    catch (NoSuchMethodException e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.componentNotConfigurable(component.getClass().getName(), e);
                    }
                }
                return this.wrapper.apply(component);
            }
            catch (PrivilegedActionException e) {
                throw new StartException(e.getCause());
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new StartException((Throwable)e);
            }
        }
    }
}

