/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.buffer;

import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.buffer.TimedBufferObserver;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalComponentImpl;
import org.jboss.logging.Logger;

public final class TimedBuffer
extends CriticalComponentImpl {
    protected static final int CRITICAL_PATHS = 6;
    protected static final int CRITICAL_PATH_FLUSH = 0;
    protected static final int CRITICAL_PATH_STOP = 1;
    protected static final int CRITICAL_PATH_START = 2;
    protected static final int CRITICAL_PATH_CHECK_SIZE = 3;
    protected static final int CRITICAL_PATH_ADD_BYTES = 4;
    protected static final int CRITICAL_PATH_SET_OBSERVER = 5;
    private static final Logger logger = Logger.getLogger(TimedBuffer.class);
    private static final double MAX_TIMEOUT_ERROR_FACTOR = 1.5;
    private static final int MAX_CHECKS_ON_SLEEP = 20;
    private TimedBufferObserver bufferObserver;
    private final Semaphore spinLimiter = new Semaphore(1);
    private CheckTimer timerRunnable;
    private final int bufferSize;
    private final ActiveMQBuffer buffer;
    private int bufferLimit = 0;
    private List<IOCallback> callbacks;
    private final int timeout;
    private volatile boolean pendingSync = false;
    private Thread timerThread;
    private volatile boolean started;
    private boolean delayFlush;
    private final boolean logRates;
    private final AtomicLong bytesFlushed = new AtomicLong(0L);
    private final AtomicLong flushesDone = new AtomicLong(0L);
    private Timer logRatesTimer;
    private TimerTask logRatesTimerTask;
    private boolean spinning = false;

    public TimedBuffer(CriticalAnalyzer analyzer, int size, int timeout, boolean logRates) {
        super(analyzer, 6);
        this.bufferSize = size;
        this.logRates = logRates;
        if (logRates) {
            this.logRatesTimer = new Timer(true);
        }
        this.buffer = new ChannelBufferWrapper(Unpooled.wrappedBuffer((ByteBuffer)ByteBuffer.allocateDirect(size)));
        this.buffer.clear();
        this.bufferLimit = 0;
        this.callbacks = new ArrayList<IOCallback>();
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.enterCritical(2);
        try {
            TimedBuffer timedBuffer = this;
            synchronized (timedBuffer) {
                block11: {
                    if (!this.started) break block11;
                    return;
                }
                try {
                    this.spinLimiter.acquire();
                }
                catch (InterruptedException e) {
                    throw new ActiveMQInterruptedException((Throwable)e);
                }
                this.timerRunnable = new CheckTimer();
                this.timerThread = new Thread((Runnable)this.timerRunnable, "activemq-buffer-timeout");
                this.timerThread.start();
                if (this.logRates) {
                    this.logRatesTimerTask = new LogRatesTimerTask();
                    this.logRatesTimer.scheduleAtFixedRate(this.logRatesTimerTask, 2000L, 2000L);
                }
                this.started = true;
            }
        }
        finally {
            this.leaveCritical(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        this.enterCritical(1);
        Thread localTimer = null;
        try {
            TimedBuffer timedBuffer = this;
            synchronized (timedBuffer) {
                try {
                    if (!this.started) {
                        return;
                    }
                    this.flush();
                    this.bufferObserver = null;
                    this.timerRunnable.close();
                    this.spinLimiter.release();
                    if (this.logRates) {
                        this.logRatesTimerTask.cancel();
                    }
                    localTimer = this.timerThread;
                    this.timerThread = null;
                }
                finally {
                    this.started = false;
                }
            }
            if (localTimer == null) return;
            while (localTimer.isAlive()) {
                try {
                    localTimer.join(1000L);
                    if (!localTimer.isAlive()) continue;
                    localTimer.interrupt();
                }
                catch (InterruptedException e) {
                    throw new ActiveMQInterruptedException((Throwable)e);
                }
            }
            return;
        }
        finally {
            this.leaveCritical(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObserver(TimedBufferObserver observer) {
        this.enterCritical(5);
        try {
            TimedBuffer timedBuffer = this;
            synchronized (timedBuffer) {
                if (this.bufferObserver != null) {
                    this.flush();
                }
                this.bufferObserver = observer;
            }
        }
        finally {
            this.leaveCritical(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean checkSize(int sizeChecked) {
        block9: {
            int remainingInFile;
            block10: {
                boolean bl;
                this.enterCritical(3);
                try {
                    TimedBuffer timedBuffer = this;
                    // MONITORENTER : timedBuffer
                    if (!this.started) {
                        throw new IllegalStateException("TimedBuffer is not started");
                    }
                    if (sizeChecked > this.bufferSize) {
                        throw new IllegalStateException("Can't write records bigger than the bufferSize(" + this.bufferSize + ") on the journal");
                    }
                    if (this.bufferLimit != 0 && this.buffer.writerIndex() + sizeChecked <= this.bufferLimit) break block9;
                    this.flush();
                    this.delayFlush = true;
                    remainingInFile = this.bufferObserver.getRemainingBytes();
                    if (sizeChecked <= remainingInFile) break block10;
                    bl = false;
                    // MONITOREXIT : timedBuffer
                }
                catch (Throwable throwable) {
                    this.leaveCritical(3);
                    throw throwable;
                }
                this.leaveCritical(3);
                return bl;
            }
            this.bufferLimit = Math.min(remainingInFile, this.bufferSize);
            boolean bl = true;
            // MONITOREXIT : timedBuffer
            this.leaveCritical(3);
            return bl;
        }
        this.delayFlush = true;
        boolean bl = true;
        // MONITOREXIT : timedBuffer
        this.leaveCritical(3);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBytes(ActiveMQBuffer bytes, boolean sync, IOCallback callback) {
        this.enterCritical(4);
        try {
            TimedBuffer timedBuffer = this;
            synchronized (timedBuffer) {
                if (!this.started) {
                    throw new IllegalStateException("TimedBuffer is not started");
                }
                this.delayFlush = false;
                int readableBytes = bytes.readableBytes();
                int writerIndex = this.buffer.writerIndex();
                this.buffer.setBytes(writerIndex, bytes, bytes.readerIndex(), readableBytes);
                this.buffer.writerIndex(writerIndex + readableBytes);
                this.callbacks.add(callback);
                if (sync) {
                    this.pendingSync = true;
                    this.startSpin();
                }
            }
        }
        finally {
            this.leaveCritical(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBytes(EncodingSupport bytes, boolean sync, IOCallback callback) {
        this.enterCritical(4);
        try {
            TimedBuffer timedBuffer = this;
            synchronized (timedBuffer) {
                if (!this.started) {
                    throw new IllegalStateException("TimedBuffer is not started");
                }
                this.delayFlush = false;
                bytes.encode(this.buffer);
                this.callbacks.add(callback);
                if (sync) {
                    this.pendingSync = true;
                    this.startSpin();
                }
            }
        }
        finally {
            this.leaveCritical(4);
        }
    }

    public void flush() {
        this.flushBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean flushBatch() {
        block8: {
            boolean bl;
            this.enterCritical(0);
            try {
                TimedBuffer timedBuffer = this;
                // MONITORENTER : timedBuffer
                if (!this.started) {
                    throw new IllegalStateException("TimedBuffer is not started");
                }
                if (this.delayFlush || this.buffer.writerIndex() <= 0) break block8;
                int pos = this.buffer.writerIndex();
                if (this.logRates) {
                    this.bytesFlushed.addAndGet(pos);
                }
                ByteBuffer bufferToFlush = this.bufferObserver.newBuffer(this.bufferSize, pos);
                bufferToFlush.limit(pos);
                this.buffer.getBytes(0, bufferToFlush);
                this.bufferObserver.flushBuffer(bufferToFlush, this.pendingSync, this.callbacks);
                this.stopSpin();
                this.pendingSync = false;
                this.callbacks = new ArrayList<IOCallback>();
                this.buffer.clear();
                this.bufferLimit = 0;
                this.flushesDone.incrementAndGet();
                bl = pos > 0;
                // MONITOREXIT : timedBuffer
            }
            catch (Throwable throwable) {
                this.leaveCritical(0);
                throw throwable;
            }
            this.leaveCritical(0);
            return bl;
        }
        boolean bl = false;
        // MONITOREXIT : timedBuffer
        this.leaveCritical(0);
        return bl;
    }

    protected void sleep(long sleepNanos) {
        LockSupport.parkNanos(sleepNanos);
    }

    protected void stopSpin() {
        if (this.spinning) {
            try {
                this.spinLimiter.acquire();
            }
            catch (InterruptedException e) {
                throw new ActiveMQInterruptedException((Throwable)e);
            }
            this.spinning = false;
        }
    }

    protected void startSpin() {
        if (!this.spinning) {
            this.spinLimiter.release();
            this.spinning = true;
        }
    }

    private class CheckTimer
    implements Runnable {
        private volatile boolean closed = false;
        int checks = 0;
        int failedChecks = 0;

        private CheckTimer() {
        }

        @Override
        public void run() {
            long lastFlushTime = System.nanoTime();
            boolean useSleep = true;
            while (!this.closed) {
                if (TimedBuffer.this.pendingSync) {
                    if (useSleep) {
                        lastFlushTime = System.nanoTime();
                        if (TimedBuffer.this.flushBatch()) {
                            long timeFromTheLastFlush = System.nanoTime() - lastFlushTime;
                            long timeToSleep = (long)TimedBuffer.this.timeout - timeFromTheLastFlush;
                            if (timeToSleep > 0L) {
                                useSleep = this.sleepIfPossible(timeToSleep);
                            }
                        }
                    } else if (TimedBuffer.this.bufferObserver != null && System.nanoTime() - lastFlushTime > (long)TimedBuffer.this.timeout) {
                        lastFlushTime = System.nanoTime();
                        TimedBuffer.this.flush();
                    }
                }
                try {
                    TimedBuffer.this.spinLimiter.acquire();
                    Thread.yield();
                    TimedBuffer.this.spinLimiter.release();
                }
                catch (InterruptedException e) {
                    throw new ActiveMQInterruptedException((Throwable)e);
                }
            }
        }

        private boolean sleepIfPossible(long nanosToSleep) {
            boolean useSleep = true;
            try {
                long startSleep = System.nanoTime();
                TimedBuffer.this.sleep(nanosToSleep);
                if (this.checks < 20) {
                    long elapsedSleep = System.nanoTime() - startSleep;
                    if ((double)elapsedSleep > (double)nanosToSleep * 1.5) {
                        ++this.failedChecks;
                    }
                    if (++this.checks >= 20 && (double)this.failedChecks > 10.0) {
                        logger.debug((Object)"LockSupport.parkNanos with nano seconds is not working as expected, Your kernel possibly doesn't support real time. the Journal TimedBuffer will spin for timeouts");
                        useSleep = false;
                    }
                }
            }
            catch (Exception e) {
                useSleep = false;
                logger.warn((Object)(e.getMessage() + ", disabling sleep on TimedBuffer, using spin now"), (Throwable)e);
            }
            return useSleep;
        }

        public void close() {
            this.closed = true;
        }
    }

    private class LogRatesTimerTask
    extends TimerTask {
        private boolean closed;
        private long lastExecution;
        private long lastBytesFlushed;
        private long lastFlushesDone;

        private LogRatesTimerTask() {
        }

        @Override
        public synchronized void run() {
            if (!this.closed) {
                long now = System.currentTimeMillis();
                long bytesF = TimedBuffer.this.bytesFlushed.get();
                long flushesD = TimedBuffer.this.flushesDone.get();
                if (this.lastExecution != 0L) {
                    double rate = 1000.0 * (double)(bytesF - this.lastBytesFlushed) / (double)(now - this.lastExecution);
                    ActiveMQJournalLogger.LOGGER.writeRate(rate, (long)(rate / 1048576.0));
                    double flushRate = 1000.0 * (double)(flushesD - this.lastFlushesDone) / (double)(now - this.lastExecution);
                    ActiveMQJournalLogger.LOGGER.flushRate(flushRate);
                }
                this.lastExecution = now;
                this.lastBytesFlushed = bytesF;
                this.lastFlushesDone = flushesD;
            }
        }

        @Override
        public synchronized boolean cancel() {
            this.closed = true;
            return super.cancel();
        }
    }
}

