/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.Externalizer;

public class StringExternalizer<T>
implements Externalizer<T> {
    private final Function<String, T> reader;
    private final Function<T, String> writer;
    private final Class<T> targetClass;

    public StringExternalizer(Class<T> targetClass, Function<String, T> reader) {
        this(targetClass, reader, Object::toString);
    }

    public StringExternalizer(Class<T> targetClass, Function<String, T> reader, Function<T, String> writer) {
        this.reader = reader;
        this.writer = writer;
        this.targetClass = targetClass;
    }

    public void writeObject(ObjectOutput output, T object) throws IOException {
        output.writeUTF(this.writer.apply(object));
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return this.reader.apply(input.readUTF());
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }
}

