/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.time;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Duration;
import org.wildfly.clustering.marshalling.Externalizer;

public class DurationExternalizer
implements Externalizer<Duration> {
    public void writeObject(ObjectOutput output, Duration duration) throws IOException {
        output.writeLong(duration.getSeconds());
        output.writeInt(duration.getNano());
    }

    public Duration readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        long seconds = input.readLong();
        int nanos = input.readInt();
        return Duration.ofSeconds(seconds, nanos);
    }

    public Class<Duration> getTargetClass() {
        return Duration.class;
    }
}

