/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr.stream;

import org.jboss.dmr.stream.ModelEvent;
import org.jboss.dmr.stream.ModelException;

final class ModelGrammarAnalyzer {
    private static final byte LIST_START = 1;
    private static final byte OBJECT_START = 2;
    private static final byte PROPERTY_START = 4;
    private static final byte STRING = 8;
    private static final byte ARROW = 16;
    private boolean canWriteComma;
    private boolean canWriteArrow;
    private boolean expectedPropertyEnd;
    private byte[] stack = new byte[8];
    private int index;
    ModelEvent currentEvent;
    boolean finished;

    ModelGrammarAnalyzer() {
    }

    boolean isArrowExpected() {
        return this.canWriteArrow;
    }

    boolean isCommaExpected() {
        return this.canWriteComma;
    }

    void putObjectEnd() throws ModelException {
        if (this.finished || this.index == 0 || this.stack[this.index - 1] != 2) {
            throw this.newModelException(this.getExpectingTokensMessage());
        }
        this.currentEvent = ModelEvent.OBJECT_END;
        --this.index;
        if (this.index > 0) {
            if (this.stack[this.index - 1] == 16) {
                this.index -= 2;
                this.canWriteComma = (this.stack[this.index - 1] & 3) != 0;
                this.expectedPropertyEnd = this.stack[this.index - 1] == 4;
            } else if (this.stack[this.index - 1] == 1) {
                this.canWriteComma = true;
            }
        }
        if (this.index == 0) {
            this.finished = true;
        }
    }

    void putListEnd() throws ModelException {
        if (this.finished || this.index == 0 || this.stack[this.index - 1] != 1) {
            throw this.newModelException(this.getExpectingTokensMessage());
        }
        this.currentEvent = ModelEvent.LIST_END;
        --this.index;
        if (this.index > 0) {
            if (this.stack[this.index - 1] == 16) {
                this.index -= 2;
                this.canWriteComma = (this.stack[this.index - 1] & 3) != 0;
                this.expectedPropertyEnd = this.stack[this.index - 1] == 4;
            } else if (this.stack[this.index - 1] == 1) {
                this.canWriteComma = true;
            }
        } else {
            this.finished = true;
        }
    }

    void putPropertyEnd() throws ModelException {
        if (this.finished || this.index == 0 || this.stack[this.index - 1] != 4 || !this.expectedPropertyEnd) {
            throw this.newModelException(this.getExpectingTokensMessage());
        }
        this.currentEvent = ModelEvent.PROPERTY_END;
        this.expectedPropertyEnd = false;
        --this.index;
        if (this.index > 0) {
            if (this.stack[this.index - 1] == 16) {
                this.index -= 2;
                this.canWriteComma = (this.stack[this.index - 1] & 3) != 0;
                this.expectedPropertyEnd = this.stack[this.index - 1] == 4;
            } else if (this.stack[this.index - 1] == 1) {
                this.canWriteComma = true;
            }
        } else {
            this.finished = true;
        }
    }

    void putExpression() throws ModelException {
        if (this.finished || this.canWriteComma || this.index != 0 && (this.stack[this.index - 1] & 0x11) == 0) {
            throw this.newModelException(this.getExpectingTokensMessage());
        }
        this.currentEvent = ModelEvent.EXPRESSION;
        if (this.index == 0) {
            this.finished = true;
            return;
        }
        if (this.stack[this.index - 1] == 16) {
            this.index -= 2;
        }
        this.canWriteComma = (this.stack[this.index - 1] & 3) != 0;
        this.expectedPropertyEnd = this.stack[this.index - 1] == 4;
    }

    void putNumber(ModelEvent numberEvent) throws ModelException {
        if (this.finished || this.canWriteComma || this.index != 0 && (this.stack[this.index - 1] & 0x11) == 0) {
            throw this.newModelException(this.getExpectingTokensMessage());
        }
        this.currentEvent = numberEvent;
        if (this.index == 0) {
            this.finished = true;
            return;
        }
        if (this.stack[this.index - 1] == 16) {
            this.index -= 2;
        }
        this.canWriteComma = (this.stack[this.index - 1] & 3) != 0;
        this.expectedPropertyEnd = this.stack[this.index - 1] == 4;
    }

    void putBoolean() throws ModelException {
        if (this.finished || this.canWriteComma || this.index != 0 && (this.stack[this.index - 1] & 0x11) == 0) {
            throw this.newModelException(this.getExpectingTokensMessage());
        }
        this.currentEvent = ModelEvent.BOOLEAN;
        if (this.index == 0) {
            this.finished = true;
            return;
        }
        if (this.stack[this.index - 1] == 16) {
            this.index -= 2;
        }
        this.canWriteComma = (this.stack[this.index - 1] & 3) != 0;
        this.expectedPropertyEnd = this.stack[this.index - 1] == 4;
    }

    void putBytes() throws ModelException {
        if (this.finished || this.canWriteComma || this.index != 0 && (this.stack[this.index - 1] & 0x11) == 0) {
            throw this.newModelException(this.getExpectingTokensMessage());
        }
        this.currentEvent = ModelEvent.BYTES;
        if (this.index == 0) {
            this.finished = true;
            return;
        }
        if (this.stack[this.index - 1] == 16) {
            this.index -= 2;
        }
        this.canWriteComma = (this.stack[this.index - 1] & 3) != 0;
        this.expectedPropertyEnd = this.stack[this.index - 1] == 4;
    }

    void putUndefined() throws ModelException {
        if (this.finished || this.canWriteComma || this.index != 0 && (this.stack[this.index - 1] & 0x11) == 0) {
            throw this.newModelException(this.getExpectingTokensMessage());
        }
        this.currentEvent = ModelEvent.UNDEFINED;
        if (this.index == 0) {
            this.finished = true;
            return;
        }
        if (this.stack[this.index - 1] == 16) {
            this.index -= 2;
        }
        this.canWriteComma = (this.stack[this.index - 1] & 3) != 0;
        this.expectedPropertyEnd = this.stack[this.index - 1] == 4;
    }

    void putType() throws ModelException {
        if (this.finished || this.canWriteComma || this.index != 0 && (this.stack[this.index - 1] & 0x11) == 0) {
            throw this.newModelException(this.getExpectingTokensMessage());
        }
        this.currentEvent = ModelEvent.TYPE;
        if (this.index == 0) {
            this.finished = true;
            return;
        }
        if (this.stack[this.index - 1] == 16) {
            this.index -= 2;
        }
        this.canWriteComma = (this.stack[this.index - 1] & 3) != 0;
        this.expectedPropertyEnd = this.stack[this.index - 1] == 4;
    }

    void putString() throws ModelException {
        if (this.finished || this.canWriteComma || this.expectedPropertyEnd || this.index != 0 && (this.stack[this.index - 1] & 0x17) == 0) {
            throw this.newModelException(this.getExpectingTokensMessage());
        }
        this.currentEvent = ModelEvent.STRING;
        if (this.index == 0) {
            this.finished = true;
            return;
        }
        if (this.stack[this.index - 1] == 2) {
            if (this.index == this.stack.length) {
                this.doubleStack();
            }
            this.stack[this.index++] = 8;
            this.canWriteArrow = true;
            return;
        }
        if (this.stack[this.index - 1] == 4) {
            if (this.index == this.stack.length) {
                this.doubleStack();
            }
            this.stack[this.index++] = 8;
            this.canWriteArrow = true;
            return;
        }
        if (this.stack[this.index - 1] == 16) {
            this.index -= 2;
        }
        this.canWriteComma = (this.stack[this.index - 1] & 3) != 0;
        this.expectedPropertyEnd = this.stack[this.index - 1] == 4;
    }

    void putObjectStart() throws ModelException {
        if (this.finished || this.canWriteComma || this.index != 0 && (this.stack[this.index - 1] & 0x11) == 0) {
            throw this.newModelException(this.getExpectingTokensMessage());
        }
        this.currentEvent = ModelEvent.OBJECT_START;
        if (this.index == this.stack.length) {
            this.doubleStack();
        }
        this.stack[this.index++] = 2;
    }

    void putListStart() throws ModelException {
        if (this.finished || this.canWriteComma || this.index != 0 && (this.stack[this.index - 1] & 0x11) == 0) {
            throw this.newModelException(this.getExpectingTokensMessage());
        }
        this.currentEvent = ModelEvent.LIST_START;
        if (this.index == this.stack.length) {
            this.doubleStack();
        }
        this.stack[this.index++] = 1;
    }

    void putPropertyStart() throws ModelException {
        if (this.finished || this.canWriteComma || this.index != 0 && (this.stack[this.index - 1] & 0x11) == 0) {
            throw this.newModelException(this.getExpectingTokensMessage());
        }
        this.currentEvent = ModelEvent.PROPERTY_START;
        if (this.index == this.stack.length) {
            this.doubleStack();
        }
        this.stack[this.index++] = 4;
    }

    void putArrow() throws ModelException {
        if (this.finished || this.index == 0 || this.stack[this.index - 1] != 8) {
            throw this.newModelException(this.getExpectingTokensMessage());
        }
        this.currentEvent = null;
        if (this.index == this.stack.length) {
            this.doubleStack();
        }
        this.stack[this.index++] = 16;
        this.canWriteArrow = false;
    }

    void putComma() throws ModelException {
        if (this.finished || !this.canWriteComma) {
            throw this.newModelException(this.getExpectingTokensMessage());
        }
        this.currentEvent = null;
        this.canWriteComma = false;
    }

    String getExpectingTokensMessage() {
        if (this.index == 0) {
            if (!this.finished) {
                return "Expecting OBJECT_START or LIST_START or PROPERTY_START or STRING or EXPRESSION or BYTES or NUMBER or BOOLEAN or TYPE or UNDEFINED";
            }
            return "Expecting EOF";
        }
        if (this.stack[this.index - 1] == 2) {
            if (!this.canWriteComma) {
                return "Expecting OBJECT_END or STRING";
            }
            return "Expecting ',' or OBJECT_END";
        }
        if (this.stack[this.index - 1] == 4) {
            if (!this.expectedPropertyEnd) {
                return "Expecting STRING";
            }
            return "Expecting PROPERTY_END";
        }
        if (this.stack[this.index - 1] == 1) {
            if (!this.canWriteComma) {
                if (this.currentEvent != null) {
                    return "Expecting LIST_END or OBJECT_START or LIST_START or PROPERTY_START or STRING or EXPRESSION or BYTES or NUMBER or BOOLEAN or TYPE or UNDEFINED";
                }
                return "Expecting OBJECT_START or LIST_START or PROPERTY_START or STRING or EXPRESSION or BYTES or NUMBER or BOOLEAN or TYPE or UNDEFINED";
            }
            return "Expecting ',' or LIST_END";
        }
        if (this.stack[this.index - 1] == 16) {
            return "Expecting OBJECT_START or LIST_START or PROPERTY_START or STRING or EXPRESSION or BYTES or NUMBER or BOOLEAN or TYPE or UNDEFINED";
        }
        if (this.stack[this.index - 1] == 8) {
            return "Expecting '=>'";
        }
        throw new IllegalStateException();
    }

    private void doubleStack() {
        byte[] oldData = this.stack;
        this.stack = new byte[oldData.length * 2];
        System.arraycopy(oldData, 0, this.stack, 0, oldData.length);
    }

    ModelException newModelException(String s) {
        this.finished = true;
        this.currentEvent = null;
        return new ModelException(s);
    }

    ModelException newModelException(String s, Throwable t) {
        this.finished = true;
        this.currentEvent = null;
        return new ModelException(s, t);
    }
}

