/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.AbstractDeploymentUnitService;
import org.jboss.as.server.deployment.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class DeploymentStatusHandler
implements OperationStepHandler {
    public static final OperationStepHandler INSTANCE = new DeploymentStatusHandler();
    private static final ModelNode NO_METRICS = new ModelNode("no metrics available");

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode deployment = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        final boolean isEnabled = DeploymentAttributes.ENABLED.resolveModelAttribute(context, deployment).asBoolean();
        final String runtimeName = DeploymentAttributes.RUNTIME_NAME.resolveModelAttribute(context, deployment).asString();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) {
                ModelNode result = context.getResult();
                if (!isEnabled) {
                    result.set(AbstractDeploymentUnitService.DeploymentStatus.STOPPED.toString());
                } else {
                    ServiceController controller = context.getServiceRegistry(false).getService(Services.deploymentUnitName(runtimeName));
                    if (controller != null) {
                        if (controller.getState() == ServiceController.State.DOWN && controller.getUnavailableDependencies().size() == 0) {
                            result.set(AbstractDeploymentUnitService.DeploymentStatus.STOPPED.toString());
                        } else {
                            result.set(((AbstractDeploymentUnitService)controller.getService()).getStatus().toString());
                        }
                    } else {
                        result.set(NO_METRICS);
                    }
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }
}

