/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.QueuelessThreadPoolAdd;
import org.jboss.as.threads.QueuelessThreadPoolService;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.as.threads.ThreadsWriteAttributeOperationHandler;
import org.jboss.as.threads.TimeSpec;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class QueuelessThreadPoolWriteAttributeHandler
extends ThreadsWriteAttributeOperationHandler {
    private final ServiceName serviceNameBase;

    public QueuelessThreadPoolWriteAttributeHandler(boolean blocking, ServiceName serviceNameBase) {
        super(blocking ? QueuelessThreadPoolAdd.BLOCKING_ATTRIBUTES : QueuelessThreadPoolAdd.NON_BLOCKING_ATTRIBUTES, QueuelessThreadPoolAdd.RW_ATTRIBUTES);
        this.serviceNameBase = serviceNameBase;
    }

    @Override
    protected void applyOperation(OperationContext context, ModelNode model, String attributeName, ServiceController<?> service, boolean forRollback) throws OperationFailedException {
        QueuelessThreadPoolService pool = (QueuelessThreadPoolService)service.getService();
        if (PoolAttributeDefinitions.KEEPALIVE_TIME.getName().equals(attributeName)) {
            TimeUnit defaultUnit = pool.getKeepAliveUnit();
            TimeSpec spec = QueuelessThreadPoolWriteAttributeHandler.getTimeSpec(context, model, defaultUnit);
            pool.setKeepAlive(spec);
        } else if (PoolAttributeDefinitions.MAX_THREADS.getName().equals(attributeName)) {
            pool.setMaxThreads(PoolAttributeDefinitions.MAX_THREADS.resolveModelAttribute(context, model).asInt());
        } else if (!forRollback) {
            throw ThreadsLogger.ROOT_LOGGER.unsupportedQueuelessThreadPoolAttribute(attributeName);
        }
    }

    @Override
    protected ServiceController<?> getService(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = Util.getNameFromAddress((ModelNode)model.require("address"));
        ServiceName serviceName = this.serviceNameBase.append(new String[]{name});
        ServiceController controller = context.getServiceRegistry(true).getService(serviceName);
        if (controller == null) {
            throw ThreadsLogger.ROOT_LOGGER.queuelessThreadPoolServiceNotFound(serviceName);
        }
        return controller;
    }
}

