/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.JBossThreadFactory;

public final class ThreadFactoryService
implements Service<ThreadFactory> {
    private String threadGroupName;
    private Integer priority;
    private String namePattern;
    private ThreadFactory value;

    public synchronized String getThreadGroupName() {
        return this.threadGroupName;
    }

    public synchronized void setThreadGroupName(String threadGroupName) {
        this.threadGroupName = threadGroupName;
    }

    public synchronized Integer getPriority() {
        return this.priority;
    }

    public synchronized void setPriority(Integer priority) {
        this.priority = priority;
    }

    public synchronized String getNamePattern() {
        return this.namePattern;
    }

    public synchronized void setNamePattern(String namePattern) {
        this.namePattern = namePattern;
    }

    public synchronized void start(StartContext context) throws StartException {
        final ThreadGroup threadGroup = this.threadGroupName != null ? new ThreadGroup(this.threadGroupName) : null;
        this.value = AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

            @Override
            public ThreadFactory run() {
                return new JBossThreadFactory(threadGroup, Boolean.FALSE, ThreadFactoryService.this.priority, ThreadFactoryService.this.namePattern, null, null);
            }
        });
    }

    public synchronized void stop(StopContext context) {
        this.value = null;
    }

    public synchronized ThreadFactory getValue() throws IllegalStateException {
        ThreadFactory value = this.value;
        if (value == null) {
            throw ThreadsLogger.ROOT_LOGGER.threadFactoryUninitialized();
        }
        return value;
    }
}

