/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public class KerberosCallbackHandler
implements Service<CallbackHandlerService>,
CallbackHandlerService {
    private static final String SERVICE_SUFFIX = "kerberos";
    private final boolean removeRealm;

    KerberosCallbackHandler(boolean removeRealm) {
        this.removeRealm = removeRealm;
    }

    public CallbackHandlerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    @Override
    public AuthMechanism getPreferredMechanism() {
        return AuthMechanism.KERBEROS;
    }

    @Override
    public Set<AuthMechanism> getSupplementaryMechanisms() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        return Collections.emptyMap();
    }

    public boolean isReady() {
        return true;
    }

    @Override
    public boolean isReadyForHttpChallenge() {
        return true;
    }

    @Override
    public CallbackHandler getCallbackHandler(final Map<String, Object> sharedState) {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    boolean authorized;
                    AuthorizeCallback acb;
                    if (current instanceof AuthorizeCallback) {
                        acb = (AuthorizeCallback)current;
                        authorized = acb.getAuthenticationID().equals(acb.getAuthorizationID());
                        if (authorized) {
                            String userName = acb.getAuthenticationID();
                            int atIndex = acb.getAuthenticationID().indexOf(64);
                            if (KerberosCallbackHandler.this.removeRealm && atIndex > 0) {
                                sharedState.put(SecurityRealmService.LOADED_USERNAME_KEY, userName.substring(0, atIndex));
                            }
                        } else {
                            DomainManagementLogger.SECURITY_LOGGER.tracef("Checking 'AuthorizeCallback', authorized=false, authenticationID=%s, authorizationID=%s.", acb.getAuthenticationID(), acb.getAuthorizationID());
                        }
                    } else {
                        throw new UnsupportedCallbackException(current);
                    }
                    acb.setAuthorized(authorized);
                }
            }
        };
    }

    @Override
    public SecurityRealm getElytronSecurityRealm() {
        return new KerberosSecurityRealm();
    }

    @Override
    public Function<Principal, Principal> getPrincipalMapper() {
        if (this.removeRealm) {
            return p -> {
                int atIndex = p.getName().indexOf(64);
                if (atIndex > 0) {
                    return new NamePrincipal(p.getName().substring(0, atIndex));
                }
                return p;
            };
        }
        return CallbackHandlerService.super.getPrincipalMapper();
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{KerberosCallbackHandler.SERVICE_SUFFIX});
        }
    }

    private class KerberosSecurityRealm
    implements SecurityRealm {
        private KerberosSecurityRealm() {
        }

        public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
            return new KerberosRealmIdentity(principal);
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        private class KerberosRealmIdentity
        implements RealmIdentity {
            private final Principal principal;

            KerberosRealmIdentity(Principal principal) {
                this.principal = principal;
            }

            public Principal getRealmIdentityPrincipal() {
                return this.principal;
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
                return KerberosSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName);
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                return KerberosSecurityRealm.this.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return null;
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return KerberosSecurityRealm.this.getEvidenceVerifySupport(evidenceType, algorithmName);
            }

            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                return false;
            }

            public boolean exists() throws RealmUnavailableException {
                return true;
            }
        }
    }
}

