/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import org.hornetq.api.core.HornetQBuffer;

public class ByteUtil {
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static String maxString(String value, int size) {
        if (value.length() < size) {
            return value;
        }
        return value.substring(0, size / 2) + " ... " + value.substring(value.length() - size / 2);
    }

    public static String bytesToHex(HornetQBuffer buffer, int groupSize) {
        int read = buffer.readerIndex();
        buffer.readerIndex(0);
        byte[] bufferRead = new byte[buffer.writerIndex()];
        buffer.readBytes(bufferRead);
        buffer.readerIndex(read);
        return ByteUtil.bytesToHex(bufferRead, groupSize);
    }

    public static String bytesToHex(byte[] bytes, int groupSize) {
        char[] hexChars = new char[bytes.length * 2 + ByteUtil.numberOfGroups(bytes, groupSize)];
        int outPos = 0;
        for (int j = 0; j < bytes.length; ++j) {
            if (j > 0 && j % groupSize == 0) {
                hexChars[outPos++] = 32;
            }
            int v = bytes[j] & 0xFF;
            hexChars[outPos++] = hexArray[v >>> 4];
            hexChars[outPos++] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static int numberOfGroups(byte[] bytes, int groupSize) {
        int groups = bytes.length / groupSize;
        if (bytes.length % groupSize == 0) {
            --groups;
        }
        return groups;
    }
}

