/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.resourceadapters.deployment;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Formatter;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;

public final class JBossLogPrintWriter
extends PrintWriter {
    private final String deploymentName;
    private final BasicLogger logger;
    private final Logger.Level level = Logger.Level.INFO;
    private StringBuilder buffer = new StringBuilder();
    private Formatter formatter;

    public JBossLogPrintWriter(String deploymentName, BasicLogger logger2) {
        super(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }

            @Override
            public void write(byte[] b) throws IOException {
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
            }
        });
        this.deploymentName = deploymentName;
        this.logger = logger2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) {
        Object object = this.lock;
        synchronized (object) {
            if (c == 10) {
                this.outputLogger();
            } else {
                this.buffer.append((char)c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            int i;
            int mark = 0;
            for (i = 0; i < len; ++i) {
                char c = cbuf[off + i];
                if (c != '\n') continue;
                this.buffer.append(cbuf, mark + off, i - mark);
                this.outputLogger();
                mark = i + 1;
            }
            this.buffer.append(cbuf, mark + off, i - mark);
        }
    }

    @Override
    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String str, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            int i;
            int mark = 0;
            for (i = 0; i < len; ++i) {
                char c = str.charAt(off + i);
                if (c != '\n') continue;
                this.buffer.append(str.substring(mark + off, off + i));
                this.outputLogger();
                mark = i + 1;
            }
            this.buffer.append(str.substring(mark + off, off + i));
        }
    }

    @Override
    public void write(String s) {
        this.write(s, 0, s.length());
    }

    private void outputLogger() {
        if (this.buffer.length() > 0) {
            this.logger.log(this.level, (Object)(this.deploymentName + ": " + this.buffer.toString()));
            this.buffer.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            this.outputLogger();
        }
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public boolean checkError() {
        this.flush();
        return false;
    }

    @Override
    protected void setError() {
    }

    @Override
    protected void clearError() {
    }

    @Override
    public void print(boolean b) {
        this.write(String.valueOf(b));
    }

    @Override
    public void print(char c) {
        this.write(c);
    }

    @Override
    public void print(int i) {
        this.write(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.write(s);
    }

    @Override
    public void print(String s) {
        if (s != null) {
            this.write(s);
        }
    }

    @Override
    public void print(Object obj) {
        if (obj != null) {
            this.write(String.valueOf(obj));
        }
    }

    private void newLine() {
        this.outputLogger();
    }

    @Override
    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(boolean x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(int x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(long x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(float x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(double x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char[] x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(String x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(Object x) {
        String s = String.valueOf(x);
        Object object = this.lock;
        synchronized (object) {
            this.print(s);
            this.println();
        }
    }

    @Override
    public JBossLogPrintWriter printf(String format, Object ... args) {
        return this.format(format, args);
    }

    @Override
    public JBossLogPrintWriter printf(Locale l, String format, Object ... args) {
        return this.format(l, format, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JBossLogPrintWriter format(String format, Object ... args) {
        Object object = this.lock;
        synchronized (object) {
            if (this.formatter == null || this.formatter.locale() != Locale.getDefault()) {
                this.formatter = new Formatter(this);
            }
            this.formatter.format(Locale.getDefault(), format, args);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JBossLogPrintWriter format(Locale l, String format, Object ... args) {
        Object object = this.lock;
        synchronized (object) {
            if (this.formatter == null || this.formatter.locale() != l) {
                this.formatter = new Formatter(this, l);
            }
            this.formatter.format(l, format, args);
        }
        return this;
    }

    @Override
    public JBossLogPrintWriter append(CharSequence csq) {
        if (csq != null) {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public JBossLogPrintWriter append(CharSequence csq, int start, int end) {
        if (csq != null) {
            this.write(csq.subSequence(start, end).toString());
        }
        return this;
    }

    @Override
    public JBossLogPrintWriter append(char c) {
        this.write(c);
        return this;
    }
}

