/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelPool;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class ChannelRecord
extends CompletableFuture<Channel>
implements GenericFutureListener<ChannelFuture> {
    private static final Log log = LogFactory.getLog(ChannelRecord.class);
    private static final boolean trace = log.isTraceEnabled();
    static AttributeKey<ChannelRecord> KEY = AttributeKey.newInstance((String)"activation");
    private final SocketAddress unresolvedAddress;
    private final ChannelPool channelPool;
    private boolean acquired = true;

    ChannelRecord(SocketAddress unresolvedAddress, ChannelPool channelPool) {
        this.unresolvedAddress = unresolvedAddress;
        this.channelPool = channelPool;
    }

    public static ChannelRecord of(Channel channel) {
        return (ChannelRecord)channel.attr(KEY).get();
    }

    public SocketAddress getUnresolvedAddress() {
        return this.unresolvedAddress;
    }

    public ChannelPool getChannelPool() {
        return this.channelPool;
    }

    @Override
    public boolean complete(Channel channel) {
        channel.closeFuture().addListener((GenericFutureListener)this);
        return super.complete(channel);
    }

    public void operationComplete(ChannelFuture future) throws Exception {
        if (trace) {
            log.tracef("Closing channel %s", this.get());
            if (!future.isSuccess()) {
                log.tracef(future.cause(), "Channel %s is closed, see exception for details", this.get());
            }
        }
        this.channelPool.release(future.channel(), this);
    }

    void setAcquired() {
        assert (!this.acquired);
        this.acquired = true;
    }

    void setIdle() {
        assert (this.acquired);
        this.acquired = false;
    }

    public boolean isIdle() {
        return !this.acquired;
    }
}

