/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.spec;

import java.util.Arrays;
import org.wildfly.common.Assert;
import org.wildfly.security.password.spec.PasswordSpec;

public final class HashPasswordSpec
implements PasswordSpec {
    private final byte[] digest;

    public HashPasswordSpec(byte[] digest) {
        Assert.checkNotNullParam("digest", digest);
        this.digest = digest;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public boolean equals(Object other) {
        return other instanceof HashPasswordSpec && Arrays.equals(this.digest, ((HashPasswordSpec)other).digest);
    }

    public int hashCode() {
        return Arrays.hashCode(this.digest);
    }
}

