/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServer;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;

public final class AuthenticationTimeoutSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    public static final long DEFAULT_TIMEOUT = 150L;
    private final ScheduledExecutorService scheduledExecutorService;

    public AuthenticationTimeoutSaslServerFactory(SaslServerFactory delegate, ScheduledExecutorService scheduledExecutorService) {
        super(delegate);
        Assert.checkNotNullParam("scheduledExecutorService", scheduledExecutorService);
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        long timeout = props.containsKey("wildfly.sasl.authentication-timeout") ? Long.parseLong((String)props.get("wildfly.sasl.authentication-timeout")) : 150L;
        SaslServer delegateSaslServer = this.delegate.createSaslServer(mechanism, protocol, serverName, props, cbh);
        return delegateSaslServer == null ? null : new DelegatingTimeoutSaslServer(delegateSaslServer, this.scheduledExecutorService, timeout);
    }

    private static class DelegatingTimeoutSaslServer
    extends AbstractDelegatingSaslServer {
        private boolean complete;
        private boolean terminated;
        private ScheduledFuture<Void> timeoutTask;

        DelegatingTimeoutSaslServer(SaslServer delegate, ScheduledExecutorService scheduledExecutorService, long timeout) {
            super(delegate);
            this.timeoutTask = scheduledExecutorService.schedule(() -> {
                DelegatingTimeoutSaslServer delegatingTimeoutSaslServer = this;
                synchronized (delegatingTimeoutSaslServer) {
                    if (!this.isComplete() || this.complete) {
                        this.dispose();
                        this.terminated = true;
                    } else {
                        this.complete = true;
                    }
                    return null;
                }
            }, timeout, TimeUnit.SECONDS);
        }

        @Override
        public synchronized byte[] evaluateResponse(byte[] response) throws SaslException {
            if (this.terminated) {
                throw ElytronMessages.sasl.mechServerTimedOut().toSaslException();
            }
            try {
                byte[] challenge = this.delegate.evaluateResponse(response);
                if (this.isComplete() && !this.complete) {
                    this.complete = true;
                    this.cancelTimeoutTask();
                }
                return challenge;
            }
            catch (Error | RuntimeException | SaslException e) {
                if (this.isComplete() && !this.complete) {
                    this.complete = true;
                    this.cancelTimeoutTask();
                }
                throw e;
            }
        }

        @Override
        public synchronized void dispose() throws SaslException {
            this.cancelTimeoutTask();
            super.dispose();
        }

        private synchronized void cancelTimeoutTask() {
            ScheduledFuture<Void> task = this.timeoutTask;
            this.timeoutTask = null;
            if (task != null) {
                task.cancel(true);
            }
        }
    }
}

