/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert;

import java.security.cert.CRLReason;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.wildfly.common.Assert;
import org.wildfly.security.asn1.ASN1Encodable;
import org.wildfly.security.asn1.ASN1Encoder;
import org.wildfly.security.x500.GeneralName;
import org.wildfly.security.x500.X500AttributeTypeAndValue;

public final class CRLDistributionPoint
implements ASN1Encodable {
    private final DistributionPointName distributionPoint;
    private final EnumSet<CRLReason> reasons;
    private final List<GeneralName> crlIssuer;

    public CRLDistributionPoint(DistributionPointName distributionPoint, EnumSet<CRLReason> reasons, List<GeneralName> crlIssuer) {
        this.distributionPoint = distributionPoint;
        this.reasons = reasons;
        this.crlIssuer = crlIssuer;
    }

    @Override
    public void encodeTo(ASN1Encoder encoder) {
        if (this.distributionPoint != null) {
            encoder.encodeImplicit(0);
            this.distributionPoint.encodeTo(encoder);
        }
        if (this.reasons != null) {
            encoder.encodeImplicit(1);
            encoder.encodeBitString(this.reasons);
        }
        if (this.crlIssuer != null) {
            encoder.encodeImplicit(2);
            encoder.startSequence();
            for (GeneralName name : this.crlIssuer) {
                name.encodeTo(encoder);
            }
            encoder.endSequence();
        }
    }

    public static final class RelativeToCRLIssuerDistributionPointName
    extends DistributionPointName {
        private final Collection<X500AttributeTypeAndValue> attributes;

        public RelativeToCRLIssuerDistributionPointName(Collection<X500AttributeTypeAndValue> attributes) {
            Assert.checkNotNullParam("attributes", attributes);
            Assert.checkNotEmptyParam("attributes", attributes);
            this.attributes = attributes;
        }

        @Override
        public void encodeTo(ASN1Encoder encoder) {
            encoder.encodeImplicit(1);
            encoder.startSet();
            for (X500AttributeTypeAndValue attribute : this.attributes) {
                attribute.encodeTo(encoder);
            }
            encoder.endSet();
        }
    }

    public static final class FullNameDistributionPointName
    extends DistributionPointName {
        private final List<GeneralName> fullName;

        public FullNameDistributionPointName(List<GeneralName> fullName) {
            Assert.checkNotNullParam("fullName", fullName);
            Assert.checkNotEmptyParam("fullName", fullName);
            this.fullName = fullName;
        }

        @Override
        public void encodeTo(ASN1Encoder encoder) {
            encoder.encodeImplicit(0);
            encoder.startSequence();
            for (GeneralName name : this.fullName) {
                name.encodeTo(encoder);
            }
            encoder.endSequence();
        }
    }

    public static abstract class DistributionPointName
    implements ASN1Encodable {
        DistributionPointName() {
        }
    }
}

