/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.FileInputStream;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.DestAbstract;
import org.apache.activemq.artemis.cli.commands.messages.ProducerThread;
import org.apache.activemq.artemis.cli.factory.serialize.MessageSerializer;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;

@Command(name="producer", description="It will send messages to an instance")
public class Producer
extends DestAbstract {
    public static final String DEMO_TEXT = "demo.txt";
    @Option(name={"--non-persistent"}, description="It will send messages non persistently")
    boolean nonpersistent = false;
    @Option(name={"--message-size"}, description="Size of each byteMessage (The producer will use byte message on this case)")
    int messageSize = 0;
    @Option(name={"--text-size"}, description="Size of each textMessage (The producer will use text message on this case)")
    int textMessageSize;
    @Option(name={"--object-size"}, description="Size of each ObjectMessage (The producer will use object mesasge on this case)")
    int objectSize;
    @Option(name={"--msgttl"}, description="TTL for each message")
    long msgTTL = 0L;
    @Option(name={"--group"}, description="Message Group to be used")
    String msgGroupID = null;
    @Option(name={"--data"}, description="Messages will be read form the specified file, other message options will be ignored.")
    String fileName = null;

    /*
     * WARNING - void declaration
     */
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        ConnectionFactory factory = this.createConnectionFactory();
        try (Connection connection = factory.createConnection();){
            byte[] queueId = null;
            boolean isFQQN = this.isFQQN();
            if (isFQQN) {
                queueId = this.getQueueIdFromName(this.getQueueFromFQQN(this.destination));
            }
            if (this.fileName != null) {
                Session session = connection.createSession(true, 0);
                Destination dest = this.lookupDestination(session, isFQQN);
                MessageProducer messageProducer = session.createProducer(dest);
                messageProducer.setDeliveryMode(2);
                int messageCount = 0;
                try {
                    MessageSerializer serializer = this.getMessageSerializer();
                    serializer.setInput(new FileInputStream(this.fileName), session);
                    serializer.start();
                    javax.jms.Message message = serializer.read();
                    while (message != null) {
                        if (queueId != null) {
                            ((ActiveMQMessage)message).getCoreMessage().putBytesProperty(Message.HDR_ROUTE_TO_IDS, queueId);
                        }
                        messageProducer.send(message);
                        message = serializer.read();
                        ++messageCount;
                    }
                    session.commit();
                    serializer.stop();
                }
                catch (Exception e) {
                    System.err.println("Error occurred during import.  Rolling back.");
                    session.rollback();
                    e.printStackTrace();
                    Integer message = 0;
                    if (connection != null) {
                        if (var4_4 != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable) {
                                var4_4.addSuppressed(throwable);
                            }
                        } else {
                            connection.close();
                        }
                    }
                    return message;
                }
                System.out.println("Sent " + messageCount + " Messages.");
                Integer e = messageCount;
                return e;
            }
            ProducerThread[] threadsArray = new ProducerThread[this.threads];
            for (int i = 0; i < this.threads; ++i) {
                void var9_15;
                if (this.txBatchSize > 0) {
                    Session session = connection.createSession(true, 0);
                } else {
                    Session object = connection.createSession(false, 1);
                }
                Destination dest = this.lookupDestination((Session)var9_15, isFQQN);
                threadsArray[i] = new ProducerThread((Session)var9_15, dest, i);
                threadsArray[i].setVerbose(this.verbose).setSleep(this.sleep).setPersistent(!this.nonpersistent).setMessageSize(this.messageSize).setTextMessageSize(this.textMessageSize).setObjectSize(this.objectSize).setMsgTTL(this.msgTTL).setMsgGroupID(this.msgGroupID).setTransactionBatchSize(this.txBatchSize).setMessageCount(this.messageCount).setQueueId(queueId);
            }
            for (ProducerThread thread : threadsArray) {
                thread.start();
            }
            int messagesProduced = 0;
            for (ProducerThread thread : threadsArray) {
                thread.join();
                messagesProduced += thread.getSentCount();
            }
            Integer n = messagesProduced;
            return n;
        }
    }

    public Destination lookupDestination(Session session, boolean isFQQN) throws Exception {
        Destination dest;
        if (!isFQQN) {
            dest = this.lookupDestination(session);
        } else {
            String address = this.getAddressFromFQQN(this.destination);
            if (this.isFQQNAnycast(this.getQueueFromFQQN(this.destination))) {
                String queue = this.getQueueFromFQQN(this.destination);
                if (!queue.equals(address)) {
                    throw new ActiveMQException("FQQN support is limited to Anycast queues where the queue name equals the address.");
                }
                dest = session.createQueue(address);
            } else {
                dest = session.createTopic(address);
            }
        }
        return dest;
    }

    protected boolean isFQQNAnycast(String queueName) throws Exception {
        ClientMessage message = this.getQueueAttribute(queueName, "RoutingType");
        String routingType = (String)ManagementHelper.getResult((ICoreMessage)message);
        return routingType.equalsIgnoreCase("anycast");
    }
}

