/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.HttpHandler;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import java.io.File;
import java.util.concurrent.ExecutorService;
import javax.servlet.ServletException;
import org.jboss.as.web.common.StartupContext;
import org.jboss.as.web.common.WebInjectionContainer;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class UndertowDeploymentService
implements Service<UndertowDeploymentService> {
    private final InjectedValue<ServletContainerService> container = new InjectedValue();
    private final InjectedValue<ExecutorService> serverExecutor = new InjectedValue();
    private final WebInjectionContainer webInjectionContainer;
    private final InjectedValue<Host> host = new InjectedValue();
    private final InjectedValue<DeploymentInfo> deploymentInfoInjectedValue = new InjectedValue();
    private final boolean autostart;
    private volatile DeploymentManager deploymentManager;

    public UndertowDeploymentService(WebInjectionContainer webInjectionContainer, boolean autostart) {
        this.webInjectionContainer = webInjectionContainer;
        this.autostart = autostart;
    }

    public void start(final StartContext startContext) throws StartException {
        if (this.autostart) {
            startContext.asynchronous();
            ((ExecutorService)this.serverExecutor.getValue()).submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        UndertowDeploymentService.this.startContext();
                        startContext.complete();
                    }
                    catch (Throwable e) {
                        startContext.failed(new StartException(e));
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startContext() throws ServletException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        DeploymentInfo deploymentInfo = (DeploymentInfo)this.deploymentInfoInjectedValue.getValue();
        Thread.currentThread().setContextClassLoader(deploymentInfo.getClassLoader());
        try {
            StartupContext.setInjectionContainer((WebInjectionContainer)this.webInjectionContainer);
            try {
                this.deploymentManager = ((ServletContainerService)this.container.getValue()).getServletContainer().addDeployment(deploymentInfo);
                this.deploymentManager.deploy();
                HttpHandler handler = this.deploymentManager.start();
                Deployment deployment = this.deploymentManager.getDeployment();
                ((Host)this.host.getValue()).registerDeployment(deployment, handler);
            }
            finally {
                StartupContext.setInjectionContainer(null);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void stop(final StopContext stopContext) {
        stopContext.asynchronous();
        ((ExecutorService)this.serverExecutor.getValue()).submit(new Runnable(){

            @Override
            public void run() {
                try {
                    UndertowDeploymentService.this.stopContext();
                }
                finally {
                    stopContext.complete();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopContext() {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        DeploymentInfo deploymentInfo = (DeploymentInfo)this.deploymentInfoInjectedValue.getValue();
        Thread.currentThread().setContextClassLoader(deploymentInfo.getClassLoader());
        try {
            if (this.deploymentManager != null) {
                Deployment deployment = this.deploymentManager.getDeployment();
                try {
                    ((Host)this.host.getValue()).unregisterDeployment(deployment);
                    this.deploymentManager.stop();
                }
                catch (ServletException e) {
                    throw new RuntimeException(e);
                }
                this.deploymentManager.undeploy();
                ((ServletContainerService)this.container.getValue()).getServletContainer().removeDeployment((DeploymentInfo)this.deploymentInfoInjectedValue.getValue());
            }
            UndertowDeploymentService.recursiveDelete(((DeploymentInfo)this.deploymentInfoInjectedValue.getValue()).getTempDir());
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public UndertowDeploymentService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<ServletContainerService> getContainer() {
        return this.container;
    }

    public InjectedValue<Host> getHost() {
        return this.host;
    }

    public InjectedValue<DeploymentInfo> getDeploymentInfoInjectedValue() {
        return this.deploymentInfoInjectedValue;
    }

    public Deployment getDeployment() {
        return this.deploymentManager.getDeployment();
    }

    Injector<ExecutorService> getServerExecutorInjector() {
        return this.serverExecutor;
    }

    private static void recursiveDelete(File file) {
        if (file == null) {
            return;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                UndertowDeploymentService.recursiveDelete(f);
            }
        }
        if (!file.delete()) {
            UndertowLogger.ROOT_LOGGER.couldNotDeleteTempFile(file);
        }
    }
}

