/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.constExpr;

import com.sun.tools.corba.se.idl.Util;
import com.sun.tools.corba.se.idl.constExpr.BinaryExpr;
import com.sun.tools.corba.se.idl.constExpr.EvaluationException;
import com.sun.tools.corba.se.idl.constExpr.Expression;
import java.math.BigInteger;

public class ShiftRight
extends BinaryExpr {
    protected ShiftRight(Expression leftOperand, Expression rightOperand) {
        super(">>", leftOperand, rightOperand);
    }

    @Override
    public Object evaluate() throws EvaluationException {
        try {
            Number l = (Number)this.left().evaluate();
            Number r = (Number)this.right().evaluate();
            if (l instanceof Float || l instanceof Double || r instanceof Float || r instanceof Double) {
                String[] parameters = new String[]{Util.getMessage("EvaluationException.right"), this.left().value().getClass().getName(), this.right().value().getClass().getName()};
                throw new EvaluationException(Util.getMessage("EvaluationException.1", parameters));
            }
            BigInteger bL = (BigInteger)this.coerceToTarget((BigInteger)l);
            BigInteger bR = (BigInteger)r;
            if (bL.signum() == -1) {
                if (this.type().equals("short")) {
                    bL = bL.add(twoPow16);
                } else if (this.type().equals("long")) {
                    bL = bL.add(twoPow32);
                } else if (this.type().equals("long long")) {
                    bL = bL.add(twoPow64);
                }
            }
            this.value(bL.shiftRight(bR.intValue()));
        }
        catch (ClassCastException e) {
            String[] parameters = new String[]{Util.getMessage("EvaluationException.right"), this.left().value().getClass().getName(), this.right().value().getClass().getName()};
            throw new EvaluationException(Util.getMessage("EvaluationException.1", parameters));
        }
        return this.value();
    }
}

