/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRAMessageConsumer;

public class ActiveMQRAMessageListener
implements MessageListener {
    private static boolean trace = ActiveMQRALogger.LOGGER.isTraceEnabled();
    private final MessageListener listener;
    private final ActiveMQRAMessageConsumer consumer;

    public ActiveMQRAMessageListener(MessageListener listener, ActiveMQRAMessageConsumer consumer) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("constructor(" + listener + ", " + consumer + ")");
        }
        this.listener = listener;
        this.consumer = consumer;
    }

    public void onMessage(Message message) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("onMessage(" + message + ")");
        }
        message = this.consumer.wrapMessage(message);
        this.listener.onMessage(message);
    }
}

