/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.config;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.jandex.Index;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;
import org.jipijapa.plugin.spi.TempClassLoaderFactory;

public class PersistenceUnitMetadataImpl
implements PersistenceUnitMetadata {
    private volatile String name;
    private volatile String scopedName;
    private volatile String nonJtaDataSourceName;
    private volatile String jtaDataSourceName;
    private volatile DataSource jtaDatasource;
    private volatile DataSource nonJtaDataSource;
    private volatile String provider;
    private volatile PersistenceUnitTransactionType transactionType;
    private volatile List<String> classes = new ArrayList<String>(1);
    private final List<String> packages = new ArrayList<String>(1);
    private volatile List<String> jarFiles = new ArrayList<String>(1);
    private volatile List<URL> jarFilesUrls = new ArrayList<URL>();
    private volatile URL persistenceUnitRootUrl;
    private volatile List<String> mappingFiles = new ArrayList<String>(1);
    private volatile Properties props = new Properties();
    private volatile boolean excludeUnlistedClasses;
    private volatile ValidationMode validationMode;
    private volatile String version;
    private final List<ClassTransformer> transformers = new CopyOnWriteArrayList<ClassTransformer>();
    private volatile SharedCacheMode sharedCacheMode;
    private volatile ClassLoader classloader;
    private volatile TempClassLoaderFactory tempClassLoaderFactory;
    private volatile ClassLoader cachedTempClassLoader;
    private volatile Map<URL, Index> annotationIndex;

    public void setPersistenceUnitName(String name) {
        this.name = name;
    }

    public String getPersistenceUnitName() {
        return this.name;
    }

    public void setScopedPersistenceUnitName(String scopedName) {
        this.scopedName = scopedName;
    }

    public String getScopedPersistenceUnitName() {
        return this.scopedName;
    }

    public void setPersistenceProviderClassName(String provider) {
        if (provider != null && provider.endsWith(".class")) {
            this.provider = provider.substring(0, provider.length() - 6);
        }
        this.provider = provider;
    }

    public String getPersistenceProviderClassName() {
        return this.provider;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public DataSource getJtaDataSource() {
        return this.jtaDatasource;
    }

    public void setJtaDataSource(DataSource jtaDataSource) {
        this.jtaDatasource = jtaDataSource;
    }

    public void setNonJtaDataSource(DataSource nonJtaDataSource) {
        this.nonJtaDataSource = nonJtaDataSource;
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public void setJtaDataSourceName(String jtaDatasource) {
        this.jtaDataSourceName = jtaDatasource;
    }

    public String getJtaDataSourceName() {
        return this.jtaDataSourceName;
    }

    public void setNonJtaDataSourceName(String nonJtaDatasource) {
        this.nonJtaDataSourceName = nonJtaDatasource;
    }

    public String getNonJtaDataSourceName() {
        return this.nonJtaDataSourceName;
    }

    public void setPersistenceUnitRootUrl(URL persistenceUnitRootUrl) {
        this.persistenceUnitRootUrl = persistenceUnitRootUrl;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitRootUrl;
    }

    public void setAnnotationIndex(Map<URL, Index> indexes) {
        this.annotationIndex = indexes;
    }

    public Map<URL, Index> getAnnotationIndex() {
        return this.annotationIndex;
    }

    public List<String> getManagedClassNames() {
        return this.classes;
    }

    public void setManagedClassNames(List<String> classes) {
        this.classes = classes;
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.excludeUnlistedClasses = excludeUnlistedClasses;
    }

    public void setTransactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public void setMappingFiles(List<String> mappingFiles) {
        this.mappingFiles = mappingFiles;
    }

    public List<String> getMappingFileNames() {
        return this.mappingFiles;
    }

    public List<URL> getJarFileUrls() {
        return this.jarFilesUrls;
    }

    public void setJarFileUrls(List<URL> jarFilesUrls) {
        this.jarFilesUrls = jarFilesUrls;
    }

    public List<String> getJarFiles() {
        return this.jarFiles;
    }

    public void setJarFiles(List<String> jarFiles) {
        this.jarFiles = jarFiles;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PersistenceUnitMetadataImpl(version=").append(this.version).append(") [\n").append("\tname: ").append(this.name).append("\n").append("\tjtaDataSource: ").append(this.jtaDataSourceName).append("\n").append("\tnonJtaDataSource: ").append(this.nonJtaDataSourceName).append("\n").append("\ttransactionType: ").append(this.transactionType).append("\n").append("\tprovider: ").append(this.provider).append("\n").append("\tclasses[\n");
        if (this.classes != null) {
            for (String string : this.classes) {
                sb.append("\t\t").append(string);
            }
        }
        sb.append("\t]\n").append("\tpackages[\n");
        if (this.packages != null) {
            for (String string : this.packages) {
                sb.append("\t\t").append(string).append("\n");
            }
        }
        sb.append("\t]\n").append("\tmappingFiles[\n");
        if (this.mappingFiles != null) {
            for (String string : this.mappingFiles) {
                sb.append("\t\t").append(string).append("\n");
            }
        }
        sb.append("\t]\n").append("\tjarFiles[\n");
        if (this.jarFiles != null) {
            for (String string : this.jarFiles) {
                sb.append("\t\t").append(string).append("\n");
            }
        }
        sb.append("\t]\n");
        if (this.validationMode != null) {
            sb.append("\tvalidation-mode: ").append(this.validationMode).append("\n");
        }
        if (this.sharedCacheMode != null) {
            sb.append("\tshared-cache-mode: ").append(this.sharedCacheMode).append("\n");
        }
        sb.append("\tproperties[\n");
        if (this.props != null) {
            for (Map.Entry entry : this.props.entrySet()) {
                sb.append("\t\t").append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        sb.append("\t]").append("]");
        return sb.toString();
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public void setProperties(Properties props) {
        this.props = props;
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setPersistenceXMLSchemaVersion(String version) {
        this.version = version;
    }

    public String getPersistenceXMLSchemaVersion() {
        return this.version;
    }

    public void setClassLoader(ClassLoader cl) {
        this.classloader = cl;
    }

    public ClassLoader getClassLoader() {
        return this.classloader;
    }

    public List<ClassTransformer> getTransformers() {
        return this.transformers;
    }

    public void addTransformer(ClassTransformer classTransformer) {
        this.transformers.add(classTransformer);
        if (JpaLogger.ROOT_LOGGER.isTraceEnabled()) {
            JpaLogger.ROOT_LOGGER.tracef("added entity class transformer '%s' for '%s'", classTransformer.getClass().getName(), this.getScopedPersistenceUnitName());
        }
    }

    public void setTempClassLoaderFactory(TempClassLoaderFactory tempClassloaderFactory) {
        this.tempClassLoaderFactory = tempClassloaderFactory;
        this.cachedTempClassLoader = null;
    }

    public ClassLoader cacheTempClassLoader() {
        if (this.cachedTempClassLoader == null && this.tempClassLoaderFactory != null) {
            this.cachedTempClassLoader = this.tempClassLoaderFactory.createNewTempClassLoader();
        }
        return this.cachedTempClassLoader;
    }

    public ClassLoader getNewTempClassLoader() {
        return this.tempClassLoaderFactory != null ? this.tempClassLoaderFactory.createNewTempClassLoader() : null;
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.sharedCacheMode;
    }

    public void setSharedCacheMode(SharedCacheMode sharedCacheMode) {
        this.sharedCacheMode = sharedCacheMode;
    }
}

