/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;

public class LDAPMappingConfiguration {
    private final Class<? extends AttributedType> mappedClass;
    private final Set<String> objectClasses;
    private final String baseDN;
    private final Map<String, String> mappedProperties;
    private final Property<String> idProperty;
    private final Class<? extends AttributedType> relatedAttributedType;
    private final String parentMembershipAttributeName;
    private final Map<String, String> parentMapping;
    private final Set<String> readOnlyAttributes;
    private final int hierarchySearchDepth;
    private final Property<String> bindingProperty;

    LDAPMappingConfiguration(Class<? extends AttributedType> mappedClass, Set<String> objectClasses, String baseDN, String idPropertyName, String bindingPropertyName, Map<String, String> mappedProperties, Set<String> readOnlyAttributes, Map<String, String> parentMapping, Class<? extends AttributedType> relatedAttributedType, String parentMembershipAttributeName, int hierarchySearchDepth) {
        this.mappedClass = mappedClass;
        this.objectClasses = objectClasses;
        this.baseDN = baseDN;
        this.mappedProperties = mappedProperties;
        this.readOnlyAttributes = readOnlyAttributes;
        this.parentMapping = parentMapping;
        this.hierarchySearchDepth = hierarchySearchDepth;
        this.idProperty = idPropertyName != null ? PropertyQueries.createQuery(this.getMappedClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{idPropertyName})).getFirstResult() : null;
        if (IdentityType.class.isAssignableFrom(mappedClass) && this.idProperty == null) {
            throw new SecurityConfigurationException("Id attribute not mapped to any property of [" + mappedClass + "].");
        }
        Property bindingProperty = this.idProperty;
        if (bindingPropertyName != null) {
            bindingProperty = this.getBindingProperty(bindingPropertyName);
        }
        this.bindingProperty = bindingProperty;
        this.relatedAttributedType = relatedAttributedType;
        this.parentMembershipAttributeName = parentMembershipAttributeName;
    }

    public Class<? extends AttributedType> getMappedClass() {
        return this.mappedClass;
    }

    public Set<String> getObjectClasses() {
        return this.objectClasses;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public Map<String, String> getMappedProperties() {
        return this.mappedProperties;
    }

    public Property<String> getIdProperty() {
        return this.idProperty;
    }

    public Property<String> getBindingProperty() {
        return this.bindingProperty;
    }

    public Class<? extends AttributedType> getRelatedAttributedType() {
        return this.relatedAttributedType;
    }

    public String getParentMembershipAttributeName() {
        return this.parentMembershipAttributeName;
    }

    public Map<String, String> getParentMapping() {
        return this.parentMapping;
    }

    public Set<String> getReadOnlyAttributes() {
        return this.readOnlyAttributes;
    }

    public int getHierarchySearchDepth() {
        return this.hierarchySearchDepth;
    }

    private Property getBindingProperty(final String bindingPropertyName) {
        Property bindingProperty = PropertyQueries.createQuery(this.getMappedClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{bindingPropertyName})).getFirstResult();
        if (bindingProperty == null) {
            bindingProperty = new Property<String>(){

                public String getName() {
                    return bindingPropertyName;
                }

                public Type getBaseType() {
                    return null;
                }

                public Class<String> getJavaClass() {
                    return String.class;
                }

                public AnnotatedElement getAnnotatedElement() {
                    return null;
                }

                public Member getMember() {
                    return null;
                }

                public String getValue(Object instance) {
                    if (!(instance instanceof AttributedType)) {
                        throw new IllegalStateException("Instance [ " + instance + " ] not an instance of AttributedType");
                    }
                    AttributedType attributedType = (AttributedType)instance;
                    Attribute attr = attributedType.getAttribute(bindingPropertyName);
                    return attr != null ? (String)attr.getValue() : null;
                }

                public void setValue(Object instance, String value) {
                    if (!(instance instanceof AttributedType)) {
                        throw new IllegalStateException("Instance [ " + instance + " ] not an instance of AttributedType");
                    }
                    AttributedType attributedType = (AttributedType)instance;
                    attributedType.setAttribute(new Attribute<String>(bindingPropertyName, value));
                }

                public Class<?> getDeclaringClass() {
                    return null;
                }

                public boolean isReadOnly() {
                    return false;
                }

                public void setAccessible() {
                }

                public boolean isAnnotationPresent(Class annotation) {
                    return false;
                }
            };
        }
        return bindingProperty;
    }
}

