/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.SimpleInterceptorFactoryContext;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class TimedObjectInvokerImpl
implements TimedObjectInvoker,
Serializable,
Service<TimedObjectInvoker> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"TimedObjectInvoker"});
    private final InjectedValue<EJBComponent> ejbComponent = new InjectedValue();
    private final Module module;
    private boolean started = false;
    private final String deploymentString;
    private Map<Method, Interceptor> timeoutInterceptors;

    public TimedObjectInvokerImpl(String deploymentString, Module module) {
        this.deploymentString = deploymentString;
        this.module = module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callTimeout(TimerImpl timer, Method timeoutMethod) throws Exception {
        Interceptor interceptor;
        TimedObjectInvokerImpl timedObjectInvokerImpl = this;
        synchronized (timedObjectInvokerImpl) {
            if (!this.started) {
                throw EjbLogger.EJB3_TIMER_LOGGER.timerInvocationFailedDueToInvokerNotBeingStarted();
            }
            interceptor = this.timeoutInterceptors.get(timeoutMethod);
        }
        if (interceptor == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.failToInvokeTimeout(timeoutMethod);
        }
        InterceptorContext context = new InterceptorContext();
        context.setContextData(new HashMap());
        context.setMethod(timeoutMethod);
        if (timeoutMethod.getParameterTypes().length == 0) {
            context.setParameters(new Object[0]);
        } else {
            Object[] params = new Object[]{timer};
            context.setParameters(params);
        }
        context.setTimer((Object)timer);
        context.putPrivateData(Component.class, this.ejbComponent.getValue());
        context.putPrivateData(MethodIntf.class, (Object)MethodIntf.TIMER);
        context.putPrivateData(InvocationType.class, (Object)InvocationType.TIMER);
        interceptor.processInvocation(context);
    }

    @Override
    public String getTimedObjectId() {
        return this.deploymentString + "." + ((EJBComponent)((Object)this.ejbComponent.getValue())).getComponentName();
    }

    @Override
    public void callTimeout(TimerImpl timer) throws Exception {
        this.callTimeout(timer, ((EJBComponent)((Object)this.ejbComponent.getValue())).getTimeoutMethod());
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.module.getClassLoader();
    }

    public synchronized void start(StartContext context) throws StartException {
        SimpleInterceptorFactoryContext factoryContext = new SimpleInterceptorFactoryContext();
        factoryContext.getContextData().put(Component.class, this.ejbComponent.getValue());
        HashMap<Method, Interceptor> interceptors = new HashMap<Method, Interceptor>();
        for (Map.Entry<Method, InterceptorFactory> entry : ((EJBComponent)((Object)this.ejbComponent.getValue())).getTimeoutInterceptors().entrySet()) {
            interceptors.put(entry.getKey(), entry.getValue().create((InterceptorFactoryContext)factoryContext));
        }
        this.timeoutInterceptors = interceptors;
        this.started = true;
    }

    public synchronized void stop(StopContext context) {
        this.started = false;
        this.timeoutInterceptors = null;
    }

    public synchronized TimedObjectInvoker getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<EJBComponent> getEjbComponent() {
        return this.ejbComponent;
    }
}

