/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.io.File;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import org.apache.activemq.artemis.api.core.ActiveMQAddressExistsException;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import org.apache.activemq.artemis.api.core.ActiveMQClusterSecurityException;
import org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException;
import org.apache.activemq.artemis.api.core.ActiveMQDeleteAddressException;
import org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQDuplicateMetaDataException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQIncompatibleClientServerException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidFilterExpressionException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidQueueConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidTransientQueueUseException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueMaxConsumerLimitReached;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.ActiveMQSessionCreationException;
import org.apache.activemq.artemis.api.core.ActiveMQUnexpectedRoutingTypeForAddress;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationSyncFileMessage;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.JournalType;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="AMQ")
public interface ActiveMQMessageBundle {
    public static final ActiveMQMessageBundle BUNDLE = (ActiveMQMessageBundle)Messages.getBundle(ActiveMQMessageBundle.class);

    @Message(id=119000, value="Activation for server {0}", format=Message.Format.MESSAGE_FORMAT)
    public String activationForServer(ActiveMQServer var1);

    @Message(id=119001, value="Generating thread dump", format=Message.Format.MESSAGE_FORMAT)
    public String generatingThreadDump();

    @Message(id=119002, value="Thread {0} name = {1} id = {2} group = {3}", format=Message.Format.MESSAGE_FORMAT)
    public String threadDump(Thread var1, String var2, Long var3, ThreadGroup var4);

    @Message(id=119003, value="End Thread dump")
    public String endThreadDump();

    @Message(id=119004, value="Information about server {0}\nCluster Connection:{1}", format=Message.Format.MESSAGE_FORMAT)
    public String serverDescribe(String var1, String var2);

    @Message(id=119005, value="connections for {0} closed by management", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQInternalErrorException connectionsClosedByManagement(String var1);

    @Message(id=119006, value="journals are not JournalImpl. You can''t set a replicator!")
    public ActiveMQInternalErrorException notJournalImpl();

    @Message(id=119007, value="unhandled error during replication")
    public ActiveMQInternalErrorException replicationUnhandledError(@Cause Exception var1);

    @Message(id=119008, value="Live Node contains more journals than the backup node. Probably a version match error")
    public ActiveMQInternalErrorException replicationTooManyJournals();

    @Message(id=119009, value="Unhandled file type {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQInternalErrorException replicationUnhandledFileType(ReplicationSyncFileMessage.FileType var1);

    @Message(id=119010, value="Remote Backup can not be up-to-date!")
    public ActiveMQInternalErrorException replicationBackupUpToDate();

    @Message(id=119011, value="unhandled data type!")
    public ActiveMQInternalErrorException replicationUnhandledDataType();

    @Message(id=119012, value="No binding for divert {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQInternalErrorException noBindingForDivert(SimpleString var1);

    @Message(id=119013, value="Binding {0} is not a divert", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQInternalErrorException bindingNotDivert(SimpleString var1);

    @Message(id=119014, value="Did not receive data from {0} within the {1}ms connection TTL. The connection will now be closed.", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQConnectionTimedOutException clientExited(String var1, long var2);

    @Message(id=119015, value="Must specify a name for each divert. This one will not be deployed.", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQInternalErrorException divertWithNoName();

    @Message(id=119017, value="Queue {0} does not exist", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQNonExistentQueueException noSuchQueue(SimpleString var1);

    @Message(id=119018, value="Binding already exists {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQQueueExistsException bindingAlreadyExists(Binding var1);

    @Message(id=119019, value="Queue {0} already exists on address {1}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQQueueExistsException queueAlreadyExists(SimpleString var1, SimpleString var2);

    @Message(id=119020, value="Invalid filter: {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQInvalidFilterExpressionException invalidFilter(@Cause Throwable var1, SimpleString var2);

    @Message(id=119021, value="MessageId was not assigned to Message")
    public ActiveMQIllegalStateException messageIdNotAssigned();

    @Message(id=119022, value="Cannot compare journals if not in sync!")
    public ActiveMQIllegalStateException journalsNotInSync();

    @Message(id=119023, value="Connected server is not a backup server")
    public ActiveMQIllegalStateException serverNotBackupServer();

    @Message(id=119024, value="Backup replication server is already connected to another server")
    public ActiveMQIllegalStateException alreadyHaveReplicationServer();

    @Message(id=119025, value="Cannot delete queue {0} on binding {1} - it has consumers = {2}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQIllegalStateException cannotDeleteQueue(SimpleString var1, SimpleString var2, String var3);

    @Message(id=119026, value="Backup Server was not yet in sync with live")
    public ActiveMQIllegalStateException backupServerNotInSync();

    @Message(id=119027, value="Could not find reference on consumer ID={0}, messageId = {1} queue = {2}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQIllegalStateException consumerNoReference(Long var1, Long var2, SimpleString var3);

    @Message(id=119028, value="Consumer {0} doesn''t exist on the server", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQIllegalStateException consumerDoesntExist(long var1);

    @Message(id=119029, value="No address configured on the Server''s Session")
    public ActiveMQIllegalStateException noAddress();

    @Message(id=119030, value="large-message not initialized on server")
    public ActiveMQIllegalStateException largeMessageNotInitialised();

    @Message(id=119031, value="Unable to validate user from {0}. Username: {1}; SSL certificate subject DN: {2}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQSecurityException unableToValidateUser(String var1, String var2, String var3);

    @Message(id=119032, value="User: {0} does not have permission=''{1}'' on address {2}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQSecurityException userNoPermissions(String var1, CheckType var2, String var3);

    @Message(id=119033, value="Server and client versions incompatible")
    public ActiveMQIncompatibleClientServerException incompatibleClientServer();

    @Message(id=119034, value="Server not started")
    public ActiveMQSessionCreationException serverNotStarted();

    @Message(id=119035, value="Metadata {0}={1} had been set already", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQDuplicateMetaDataException duplicateMetadata(String var1, String var2);

    @Message(id=119036, value="Invalid type: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidType(Object var1);

    @Message(id=119038, value="{0} must neither be null nor empty", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException emptyOrNull(String var1);

    @Message(id=119039, value="{0}  must be greater than 0 (actual value: {1})", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException greaterThanZero(String var1, Number var2);

    @Message(id=119040, value="{0} must be a valid percentual value between 0 and 100 (actual value: {1})", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException notPercent(String var1, Number var2);

    @Message(id=119041, value="{0}  must be equals to -1 or greater than 0 (actual value: {1})", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException greaterThanMinusOne(String var1, Number var2);

    @Message(id=119042, value="{0}  must be equals to -1 or greater or equals to 0 (actual value: {1})", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException greaterThanZeroOrMinusOne(String var1, Number var2);

    @Message(id=119043, value="{0} must be between {1} and {2} inclusive (actual value: {3})", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException mustbeBetween(String var1, Integer var2, Integer var3, Object var4);

    @Message(id=119044, value="Invalid journal type {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidJournalType(String var1);

    @Message(id=119045, value="Invalid address full message policy type {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidAddressFullPolicyType(String var1);

    @Message(id=119046, value="invalid value: {0} count must be greater than 0", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException greaterThanZero(Integer var1);

    @Message(id=119047, value="invalid value: {0} sample period must be greater than 0", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException periodMustGreaterThanZero(Long var1);

    @Message(id=119048, value="invalid new Priority value: {0}. It must be between 0 and 9 (both included)", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidNewPriority(Integer var1);

    @Message(id=119049, value="No queue found for {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException noQueueFound(String var1);

    @Message(id=119050, value="Only NIO and AsyncIO are supported journals")
    public IllegalArgumentException invalidJournal();

    @Message(id=119051, value="Invalid journal type {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidJournalType2(JournalType var1);

    @Message(id=119052, value="Directory {0} does not exist and cannot be created", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException cannotCreateDir(String var1);

    @Message(id=119054, value="Cannot convert to int")
    public IllegalArgumentException cannotConvertToInt();

    @Message(id=119055, value="Routing name is null")
    public IllegalArgumentException routeNameIsNull();

    @Message(id=119056, value="Cluster name is null")
    public IllegalArgumentException clusterNameIsNull();

    @Message(id=119057, value="Address is null")
    public IllegalArgumentException addressIsNull();

    @Message(id=119058, value="Binding type not specified")
    public IllegalArgumentException bindingTypeNotSpecified();

    @Message(id=119059, value="Binding ID is null")
    public IllegalArgumentException bindingIdNotSpecified();

    @Message(id=119060, value="Distance is null")
    public IllegalArgumentException distancenotSpecified();

    @Message(id=119061, value="Connection already exists with id {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException connectionExists(Object var1);

    @Message(id=119062, value="Acceptor with id {0} already registered", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException acceptorExists(Integer var1);

    @Message(id=119063, value="Acceptor with id {0} not registered", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException acceptorNotExists(Integer var1);

    @Message(id=119064, value="Unknown protocol {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException unknownProtocol(String var1);

    @Message(id=119065, value="node id is null")
    public IllegalArgumentException nodeIdNull();

    @Message(id=119066, value="Queue name is null")
    public IllegalArgumentException queueNameIsNull();

    @Message(id=119067, value="Cannot find resource with name {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException cannotFindResource(String var1);

    @Message(id=119068, value="no getter method for {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException noGetterMethod(String var1);

    @Message(id=119069, value="no operation {0}/{1}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException noOperation(String var1, Integer var2);

    @Message(id=119070, value="match can not be null")
    public IllegalArgumentException nullMatch();

    @Message(id=119071, value="# can only be at end of match")
    public IllegalArgumentException invalidMatch();

    @Message(id=119072, value="User cannot be null")
    public IllegalArgumentException nullUser();

    @Message(id=119073, value="Password cannot be null")
    public IllegalArgumentException nullPassword();

    @Message(id=119074, value="Error instantiating transformer class {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException errorCreatingTransformerClass(@Cause Exception var1, String var2);

    @Message(id=119075, value="method autoEncode doesn''t know how to convert {0} yet", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException autoConvertError(Class<? extends Object> var1);

    @Message(id=119076, value="Executing destroyConnection with {0}={1} through management''s request", format=Message.Format.MESSAGE_FORMAT)
    public String destroyConnectionWithSessionMetadataHeader(String var1, String var2);

    @Message(id=119077, value="Closing connection {0}", format=Message.Format.MESSAGE_FORMAT)
    public String destroyConnectionWithSessionMetadataClosingConnection(String var1);

    @Message(id=119078, value="Disconnected per admin''s request on {0}={1}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQDisconnectedException destroyConnectionWithSessionMetadataSendException(String var1, String var2);

    @Message(id=119079, value="No session found with {0}={1}", format=Message.Format.MESSAGE_FORMAT)
    public String destroyConnectionWithSessionMetadataNoSessionFound(String var1, String var2);

    @Message(id=119080, value="Invalid Page IO, PagingManager was stopped or closed")
    public ActiveMQIllegalStateException invalidPageIO();

    @Message(id=119081, value="No Discovery Group configuration named {0} found", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQException noDiscoveryGroupFound(DiscoveryGroupConfiguration var1);

    @Message(id=119082, value="Queue {0} already exists on another subscription", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQInvalidTransientQueueUseException queueSubscriptionBelongsToDifferentAddress(SimpleString var1);

    @Message(id=119083, value="Queue {0} has a different filter than requested", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQInvalidTransientQueueUseException queueSubscriptionBelongsToDifferentFilter(SimpleString var1);

    @Message(id=119099, value="Unable to authenticate cluster user: {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQClusterSecurityException unableToValidateClusterUser(String var1);

    @Message(id=119100, value="Trying to move a journal file that refers to a file instead of a directory: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException journalDirIsFile(File var1);

    @Message(id=119101, value="error trying to backup journal files at directory: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException couldNotMoveJournal(File var1);

    @Message(id=119102, value="Address \"{0}\" is full.", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAddressFullException addressIsFull(String var1);

    @Message(id=119103, value="No Connectors or Discovery Groups configured for Scale Down")
    public ActiveMQException noConfigurationFoundForScaleDown();

    @Message(id=119104, value="Server is stopping. Message grouping not allowed")
    public ActiveMQException groupWhileStopping();

    @Message(id=119106, value="Invalid slow consumer policy type {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidSlowConsumerPolicyType(String var1);

    @Message(id=119107, value="consumer connections for address {0} closed by management", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQInternalErrorException consumerConnectionsClosedByManagement(String var1);

    @Message(id=119108, value="connections for user {0} closed by management", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQInternalErrorException connectionsForUserClosedByManagement(String var1);

    @Message(id=119109, value="unsupported HA Policy Configuration {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQIllegalStateException unsupportedHAPolicyConfiguration(Object var1);

    @Message(id=119110, value="Too many sessions for user ''{0}''. Sessions allowed: {1}.", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQSessionCreationException sessionLimitReached(String var1, int var2);

    @Message(id=119111, value="Too many queues created by user ''{0}''. Queues allowed: {1}.", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQSessionCreationException queueLimitReached(String var1, int var2);

    @Message(id=119112, value="Cannot set MBeanServer during startup or while started")
    public IllegalStateException cannotSetMBeanserver();

    @Message(id=119113, value="Invalid message load balancing type {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidMessageLoadBalancingType(String var1);

    @Message(id=119114, value="Replication synchronization process timed out after waiting {0} milliseconds", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException replicationSynchronizationTimeout(long var1);

    @Message(id=119115, value="Colocated Policy hasn''t different type live and backup", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQIllegalStateException liveBackupMismatch();

    @Message(id=119116, value="Netty Acceptor unavailable", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException acceptorUnavailable();

    @Message(id=119117, value="Replicator is null. Replication was likely terminated.")
    public ActiveMQIllegalStateException replicatorIsNull();

    @Message(id=119118, value="Management method not applicable for current server configuration")
    public IllegalStateException methodNotApplicable();

    @Message(id=119119, value="Disk Capacity is Low, cannot produce more messages.")
    public ActiveMQIOErrorException diskBeyondLimit();

    @Message(id=119120, value="connection with ID {0} closed by management", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQInternalErrorException connectionWithIDClosedByManagement(String var1);

    @Message(id=119200, value="Maximum Consumer Limit Reached on Queue:(address={0},queue={1})", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQQueueMaxConsumerLimitReached maxConsumerLimitReachedForQueue(SimpleString var1, SimpleString var2);

    @Message(id=119201, value="Expected Routing Type {1} but found {2} for address {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQUnexpectedRoutingTypeForAddress unexpectedRoutingTypeForAddress(SimpleString var1, RoutingType var2, Set<RoutingType> var3);

    @Message(id=119202, value="Invalid Queue Configuration for Queue {0}, Address {1}.  Expected {2} to be {3} but was {4}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQInvalidQueueConfiguration invalidQueueConfiguration(SimpleString var1, SimpleString var2, String var3, Object var4, Object var5);

    @Message(id=119203, value="Address Does Not Exist: {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAddressDoesNotExistException addressDoesNotExist(SimpleString var1);

    @Message(id=119204, value="Address already exists: {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAddressExistsException addressAlreadyExists(SimpleString var1);

    @Message(id=119205, value="Address {0} has bindings", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQDeleteAddressException addressHasBindings(SimpleString var1);

    @Message(id=119206, value="Queue {0} has invalid max consumer setting: {1}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidMaxConsumers(String var1, int var2);

    @Message(id=119207, value="Can not create queue with routing type: {0}, Supported routing types for address: {1} are {2}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidRoutingTypeForAddress(RoutingType var1, String var2, Set<RoutingType> var3);

    @Message(id=119208, value="Invalid routing type {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidRoutingType(String var1);

    @Message(id=119209, value="Can''t remove routing type {0}, queues exists for address: {1}. Please delete queues before removing this routing type.", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException invalidRoutingTypeDelete(RoutingType var1, String var2);

    @Message(id=119210, value="Can''t update queue {0} with maxConsumers: {1}. Current consumers are {2}.", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException invalidMaxConsumersUpdate(String var1, int var2, int var3);

    @Message(id=119211, value="Can''t update queue {0} with routing type: {1}, Supported routing types for address: {2} are {3}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException invalidRoutingTypeUpdate(String var1, RoutingType var2, String var3, Set<RoutingType> var4);

    @Message(id=119212, value="Invalid deletion policy type {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException invalidDeletionPolicyType(String var1);

    @Message(id=119213, value="User: {0} does not have permission=''{1}'' for queue {2} on address {3}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQSecurityException userNoPermissionsQueue(String var1, CheckType var2, String var3, String var4);

    @Message(id=119214, value="{0} must be a valid percentage value between 0 and 100 or -1 (actual value: {1})", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException notPercentOrMinusOne(String var1, Number var2);
}

