/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jdbc.internal.model.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.jdbc.internal.model.PartitionJdbcType;
import org.picketlink.idm.jdbc.internal.model.db.AbstractStorageUtil;
import org.picketlink.idm.model.Partition;

public class PartitionStorageUtil
extends AbstractStorageUtil {
    public Partition loadPartitionById(DataSource dataSource, String id) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block5: {
            PartitionJdbcType partitionJdbcType;
            if (dataSource == null) {
                throw IDMMessages.MESSAGES.nullArgument("datasource");
            }
            connection = null;
            preparedStatement = null;
            resultSet = null;
            try {
                connection = dataSource.getConnection();
                String sql = "select name,typeName,configurationName from Partition where id =?";
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, id);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block5;
                PartitionJdbcType partition = new PartitionJdbcType(resultSet.getString(1));
                partition.setId(id);
                partition.setTypeName(resultSet.getString(2));
                partition.setConfigurationName(resultSet.getString(3));
                partitionJdbcType = partition;
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.safeClose(resultSet);
                    this.safeClose(preparedStatement);
                    this.safeClose(connection);
                    throw throwable;
                }
            }
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
            return partitionJdbcType;
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return null;
    }

    public Partition loadPartitionByName(DataSource dataSource, String name) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block5: {
            PartitionJdbcType partitionJdbcType;
            if (dataSource == null) {
                throw IDMMessages.MESSAGES.nullArgument("datasource");
            }
            connection = null;
            preparedStatement = null;
            resultSet = null;
            try {
                connection = dataSource.getConnection();
                String sql = "select id,typeName,configurationName from Partition where name =?";
                preparedStatement = connection.prepareStatement(sql);
                preparedStatement.setString(1, name);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block5;
                PartitionJdbcType partitionJdbcType2 = new PartitionJdbcType(name);
                partitionJdbcType2.setId(resultSet.getString(1));
                partitionJdbcType2.setTypeName(resultSet.getString(2));
                partitionJdbcType2.setConfigurationName(resultSet.getString(3));
                partitionJdbcType = partitionJdbcType2;
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.safeClose(resultSet);
                    this.safeClose(preparedStatement);
                    this.safeClose(connection);
                    throw throwable;
                }
            }
            this.safeClose(resultSet);
            this.safeClose(preparedStatement);
            this.safeClose(connection);
            return partitionJdbcType;
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(connection);
        return null;
    }

    public void storePartition(DataSource dataSource, PartitionJdbcType partition) {
        if (dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = dataSource.getConnection();
            String sql = "insert into Partition set name=?,id=?,typeName=?,configurationName=?";
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, partition.getName());
            preparedStatement.setString(2, partition.getId());
            preparedStatement.setString(3, partition.getTypeName());
            preparedStatement.setString(4, partition.getConfigurationName());
            int result = preparedStatement.executeUpdate();
            if (result == 0) {
                throw new RuntimeException("Insert into partition failed");
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(connection);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(connection);
    }
}

