/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.legacy;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.legacy.JBossEJBProperties;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.impl.StaticDiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryProvider;
import org.wildfly.discovery.spi.ExternalDiscoveryConfigurator;
import org.wildfly.discovery.spi.RegistryProvider;

public final class DiscoveryLegacyConfiguration
implements ExternalDiscoveryConfigurator {
    @Override
    public void configure(Consumer<DiscoveryProvider> discoveryProviderConsumer, Consumer<RegistryProvider> registryProviderConsumer) {
        JBossEJBProperties ejbProperties = JBossEJBProperties.getCurrent();
        if (ejbProperties == null) {
            return;
        }
        ArrayList<ServiceURL> list = new ArrayList<ServiceURL>();
        for (Map.Entry<String, JBossEJBProperties.ClusterConfiguration> entry : ejbProperties.getClusterConfigurations().entrySet()) {
            String clusterName = entry.getKey();
            JBossEJBProperties.ClusterConfiguration configuration = entry.getValue();
            AttributeValue clusterValue = AttributeValue.fromString(clusterName);
            for (JBossEJBProperties.ClusterNodeConfiguration nodeConfiguration : configuration.getNodeConfigurations()) {
                String nodeName = nodeConfiguration.getNodeName();
                ServiceURL.Builder abstractBuilder = new ServiceURL.Builder();
                abstractBuilder.setAbstractType("ejb");
                abstractBuilder.setAbstractTypeAuthority("jboss");
                abstractBuilder.addAttribute("cluster", clusterValue);
                try {
                    abstractBuilder.setUri(new URI("node", nodeName, null));
                }
                catch (URISyntaxException e) {
                    Logs.REMOTING.trace("Ignoring cluster node " + nodeName + " because the URI failed to be built", e);
                    continue;
                }
                list.add(abstractBuilder.create());
            }
        }
        if (!list.isEmpty()) {
            Logs.MAIN.legacyEJBPropertiesDiscoveryConfigurationInUse();
            discoveryProviderConsumer.accept(new StaticDiscoveryProvider(list));
        }
    }
}

